/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jasig.schedassist.RelationshipDao;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.IScheduleVisitor;
import org.jasig.schedassist.model.Relationship;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Qualifier(value="composite")
public class CompositeRelationshipDaoImpl
implements RelationshipDao {
    protected List<RelationshipDao> components = new ArrayList<RelationshipDao>();

    @Autowired
    public void setComponents(List<RelationshipDao> components) {
        this.components = components;
    }

    public List<Relationship> forOwner(IScheduleOwner owner) {
        LinkedHashSet union = new LinkedHashSet();
        for (RelationshipDao dao : this.components) {
            List relationships = dao.forOwner(owner);
            union.addAll(relationships);
        }
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        results.addAll(union);
        return results;
    }

    public List<Relationship> forVisitor(IScheduleVisitor visitor) {
        LinkedHashSet union = new LinkedHashSet();
        for (RelationshipDao dao : this.components) {
            List relationships = dao.forVisitor(visitor);
            union.addAll(relationships);
        }
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        results.addAll(union);
        return results;
    }
}

