/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.ICalendarAccountDao;
import org.jasig.schedassist.RelationshipDao;
import org.jasig.schedassist.impl.owner.OwnerDao;
import org.jasig.schedassist.impl.visitor.NotAVisitorException;
import org.jasig.schedassist.impl.visitor.VisitorDao;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.IScheduleVisitor;
import org.jasig.schedassist.model.Relationship;

public class StaticRelationshipDaoImpl
implements RelationshipDao {
    private Log LOG = LogFactory.getLog(this.getClass());
    private ICalendarAccountDao calendarAccountDao;
    private OwnerDao ownerDao;
    private VisitorDao visitorDao;
    private String ownerAttributeName = "uid";
    private String visitorAttributeName = "uid";
    private final Map<String, List<String>> visitorOwnerAttributePairings;
    private final Map<String, List<String>> mapReverse;
    private String relationshipDescription;

    public StaticRelationshipDaoImpl(Map<String, List<String>> visitorOwnerAttributePairings) {
        this.visitorOwnerAttributePairings = Collections.unmodifiableMap(visitorOwnerAttributePairings);
        this.mapReverse = new HashMap<String, List<String>>();
        for (String visitorUsername : this.visitorOwnerAttributePairings.keySet()) {
            List<String> ownerUsernames = this.visitorOwnerAttributePairings.get(visitorUsername);
            for (String ownerUsername : ownerUsernames) {
                List<String> visitorList = this.mapReverse.get(ownerUsername);
                if (null == visitorList) {
                    visitorList = new ArrayList<String>();
                    visitorList.add(visitorUsername);
                } else if (!visitorList.contains(visitorUsername)) {
                    visitorList.add(visitorUsername);
                }
                this.mapReverse.put(ownerUsername, visitorList);
            }
        }
    }

    public ICalendarAccountDao getCalendarAccountDao() {
        return this.calendarAccountDao;
    }

    public void setCalendarAccountDao(ICalendarAccountDao calendarAccountDao) {
        this.calendarAccountDao = calendarAccountDao;
    }

    public void setOwnerDao(OwnerDao ownerDao) {
        this.ownerDao = ownerDao;
    }

    public void setVisitorDao(VisitorDao visitorDao) {
        this.visitorDao = visitorDao;
    }

    public void setOwnerAttributeName(String ownerAttributeName) {
        this.ownerAttributeName = ownerAttributeName;
    }

    public void setVisitorAttributeName(String visitorAttributeName) {
        this.visitorAttributeName = visitorAttributeName;
    }

    public void setRelationshipDescription(String relationshipDescription) {
        this.relationshipDescription = relationshipDescription;
    }

    public List<Relationship> forOwner(IScheduleOwner owner) {
        ICalendarAccount ownerCalendarAccount = owner.getCalendarAccount();
        String ownerAttributeValue = ownerCalendarAccount.getAttributeValue(this.ownerAttributeName);
        List<String> assignedVisitorValues = this.mapReverse.get(ownerAttributeValue);
        if (null == assignedVisitorValues || assignedVisitorValues.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        for (String assignedVisitorValue : assignedVisitorValues) {
            ICalendarAccount visitorCalendarUser = this.calendarAccountDao.getCalendarAccount(this.ownerAttributeName, assignedVisitorValue);
            if (null == visitorCalendarUser) {
                this.LOG.debug((Object)("no calendar account found for " + this.ownerAttributeName + "=" + assignedVisitorValue));
                continue;
            }
            try {
                IScheduleVisitor visitor = this.visitorDao.toVisitor(visitorCalendarUser);
                if (null == owner) continue;
                Relationship relationship = new Relationship();
                relationship.setOwner(owner);
                relationship.setVisitor(visitor);
                relationship.setDescription(this.relationshipDescription);
                this.LOG.info((Object)("found owner " + owner + " for visitor " + visitor));
                results.add(relationship);
            }
            catch (NotAVisitorException e) {
                this.LOG.debug((Object)(assignedVisitorValue + " not registered as owner"));
            }
        }
        return results;
    }

    public List<Relationship> forVisitor(IScheduleVisitor visitor) {
        String vistorAttributeValue = visitor.getCalendarAccount().getAttributeValue(this.visitorAttributeName);
        List<String> assignedOwnerValues = this.visitorOwnerAttributePairings.get(vistorAttributeValue);
        if (null == assignedOwnerValues || assignedOwnerValues.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        for (String assignedOwnerValue : assignedOwnerValues) {
            ICalendarAccount ownerCalendarUser = this.calendarAccountDao.getCalendarAccount(this.ownerAttributeName, assignedOwnerValue);
            if (null == ownerCalendarUser) {
                this.LOG.debug((Object)("no calendar account found for " + this.ownerAttributeName + "=" + assignedOwnerValue));
                continue;
            }
            IScheduleOwner owner = this.ownerDao.locateOwner(ownerCalendarUser);
            if (null != owner) {
                Relationship relationship = new Relationship();
                relationship.setOwner(owner);
                relationship.setVisitor(visitor);
                relationship.setDescription(this.relationshipDescription);
                this.LOG.info((Object)("found owner " + owner + " for visitor " + visitor));
                results.add(relationship);
                continue;
            }
            this.LOG.debug((Object)(assignedOwnerValue + " not registered as owner"));
        }
        return results;
    }
}

