/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.events;

import java.util.Date;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.impl.EventType;
import org.jasig.schedassist.impl.events.AbstractAppointmentEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationListener;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class AppointmentStatisticsApplicationListener
implements ApplicationListener<AbstractAppointmentEvent> {
    private Log LOG = LogFactory.getLog(this.getClass());
    private SimpleJdbcTemplate simpleJdbcTemplate;
    private DataFieldMaxValueIncrementer statisticsEventIdSequence;

    @Autowired
    public void setDataSource(DataSource dataSource) {
        this.simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    @Autowired
    public void setStatisticsEventIdSequence(@Qualifier(value="statistics") DataFieldMaxValueIncrementer statisticsEventIdSequence) {
        this.statisticsEventIdSequence = statisticsEventIdSequence;
    }

    @Async
    public void onApplicationEvent(AbstractAppointmentEvent event) {
        EventType type = EventType.fromEvent(event);
        long eventId = this.statisticsEventIdSequence.nextLongValue();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("attempting to store event " + (Object)((Object)event) + " with new event ID " + eventId));
        }
        int rows = this.simpleJdbcTemplate.update("insert into event_statistics (event_id,owner_id,visitor_id,event_type,event_timestamp,event_start) values (?,?,?,?,?,?)", new Object[]{eventId, event.getOwner().getId(), event.getVisitor().getCalendarAccount().getUsername(), type.toString(), new Date(event.getTimestamp()), event.getBlock().getStartTime()});
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("insert complete, " + rows + " rows affected "));
        }
    }
}

