/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.owner;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.sql.DataSource;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.impl.events.AvailableScheduleChangedEvent;
import org.jasig.schedassist.impl.owner.AvailableScheduleDao;
import org.jasig.schedassist.impl.owner.PersistenceAvailableBlock;
import org.jasig.schedassist.impl.owner.PersistenceAvailableBlockRowMapper;
import org.jasig.schedassist.model.AvailableBlock;
import org.jasig.schedassist.model.AvailableBlockBuilder;
import org.jasig.schedassist.model.AvailableSchedule;
import org.jasig.schedassist.model.IScheduleOwner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="availableScheduleDao")
public class SpringJDBCAvailableScheduleDaoImpl
implements AvailableScheduleDao {
    private Log LOG = LogFactory.getLog(this.getClass());
    private SimpleJdbcTemplate simpleJdbcTemplate;
    private ApplicationEventPublisher applicationEventPublisher;

    @Autowired
    public void setDataSource(DataSource dataSource) {
        this.simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    @Autowired
    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Override
    @Transactional
    public AvailableSchedule addToSchedule(IScheduleOwner owner, AvailableBlock block) {
        SortedSet blockExpanded = AvailableBlockBuilder.expand((AvailableBlock)block, (int)1);
        return this.addToSchedule(owner, blockExpanded);
    }

    @Override
    @Transactional
    public AvailableSchedule addToSchedule(IScheduleOwner owner, Set<AvailableBlock> blocks) {
        AvailableSchedule stored = this.retrieve(owner);
        SortedSet storedExpanded = AvailableBlockBuilder.expand((Set)stored.getAvailableBlocks(), (int)1);
        SortedSet blocksExpanded = AvailableBlockBuilder.expand(blocks, (int)1);
        storedExpanded.removeAll(blocksExpanded);
        boolean modified = storedExpanded.addAll(blocksExpanded);
        if (modified) {
            this.replaceSchedule(owner, storedExpanded);
        }
        return this.retrieve(owner);
    }

    @Override
    @Transactional
    public void clearAllBlocks(IScheduleOwner owner) {
        this.LOG.warn((Object)("issuing clearAllBlocks for owner " + owner));
        int rowsUpdated = this.simpleJdbcTemplate.update("delete from schedules where owner_id = ?", new Object[]{owner.getId()});
        this.LOG.warn((Object)("deleted " + rowsUpdated + " for owner " + owner));
    }

    @Override
    @Transactional
    public AvailableSchedule removeFromSchedule(IScheduleOwner owner, AvailableBlock block) {
        SortedSet blockExpanded = AvailableBlockBuilder.expand((AvailableBlock)block, (int)1);
        return this.removeFromSchedule(owner, blockExpanded);
    }

    @Override
    @Transactional
    public AvailableSchedule removeFromSchedule(IScheduleOwner owner, Set<AvailableBlock> blocksToRemove) {
        AvailableSchedule stored = this.retrieve(owner);
        SortedSet expanded = AvailableBlockBuilder.expand((Set)stored.getAvailableBlocks(), (int)1);
        SortedSet blocksToRemoveExpanded = AvailableBlockBuilder.expand(blocksToRemove, (int)1);
        boolean modified = false;
        for (AvailableBlock toRemove : blocksToRemoveExpanded) {
            boolean result;
            if (!expanded.contains(toRemove) || !(result = expanded.remove(toRemove)) || modified) continue;
            modified = true;
        }
        if (modified) {
            this.replaceSchedule(owner, expanded);
        }
        return this.retrieve(owner);
    }

    @Override
    public AvailableSchedule retrieve(IScheduleOwner owner) {
        SortedSet<AvailableBlock> availableBlocks = this.internalRetrieveSchedule(owner);
        AvailableSchedule schedule = new AvailableSchedule(availableBlocks);
        return schedule;
    }

    @Override
    public AvailableSchedule retrieve(IScheduleOwner owner, Date startTime, Date endTime) {
        SortedSet<AvailableBlock> storedBlocks = this.internalRetrieveSchedule(owner, startTime, endTime);
        AvailableSchedule schedule = new AvailableSchedule(storedBlocks);
        return schedule;
    }

    @Override
    public AvailableSchedule retrieveWeeklySchedule(IScheduleOwner owner, Date weekOf) {
        Date weekStart = DateUtils.truncate((Date)weekOf, (int)5);
        Date weekEnd = DateUtils.addDays((Date)weekStart, (int)7);
        return this.retrieve(owner, weekStart, weekEnd);
    }

    @Override
    public AvailableBlock retrieveTargetBlock(IScheduleOwner owner, Date startDate) {
        Date truncatedStart = DateUtils.truncate((Date)startDate, (int)12);
        Date startOfDay = DateUtils.truncate((Date)startDate, (int)5);
        Date endOfDay = DateUtils.addDays((Date)startOfDay, (int)1);
        List scheduleRows = this.simpleJdbcTemplate.query("select * from schedules where owner_id = ? and start_time >= ? and end_time < ?", (RowMapper)new PersistenceAvailableBlockRowMapper(), new Object[]{owner.getId(), startOfDay, endOfDay});
        TreeSet<AvailableBlock> availableBlocks = new TreeSet<AvailableBlock>();
        for (PersistenceAvailableBlock row : scheduleRows) {
            availableBlocks.add(AvailableBlockBuilder.createBlock((Date)row.getStartTime(), (Date)row.getEndTime(), (int)row.getVisitorLimit(), (String)row.getMeetingLocation()));
        }
        int ownerPreferredMinDuration = owner.getPreferredMeetingDurations().getMinLength();
        SortedSet expanded = AvailableBlockBuilder.expand(availableBlocks, (int)ownerPreferredMinDuration);
        if (expanded.size() > 0) {
            for (AvailableBlock block : expanded) {
                if (!block.getStartTime().equals(truncatedStart)) continue;
                return block;
            }
        }
        return null;
    }

    @Override
    public AvailableBlock retrieveTargetDoubleLengthBlock(IScheduleOwner owner, Date startDate) {
        Date truncatedStart = DateUtils.truncate((Date)startDate, (int)12);
        Date startOfDay = DateUtils.truncate((Date)startDate, (int)5);
        Date endOfDay = DateUtils.addDays((Date)startOfDay, (int)1);
        List scheduleRows = this.simpleJdbcTemplate.query("select * from schedules where owner_id = ? and start_time >= ? and end_time < ?", (RowMapper)new PersistenceAvailableBlockRowMapper(), new Object[]{owner.getId(), startOfDay, endOfDay});
        TreeSet<AvailableBlock> availableBlocks = new TreeSet<AvailableBlock>();
        for (PersistenceAvailableBlock row : scheduleRows) {
            availableBlocks.add(AvailableBlockBuilder.createBlock((Date)row.getStartTime(), (Date)row.getEndTime(), (int)row.getVisitorLimit(), (String)row.getMeetingLocation()));
        }
        int ownerPreferredMinDuration = owner.getPreferredMeetingDurations().getMinLength();
        SortedSet expanded = AvailableBlockBuilder.expand(availableBlocks, (int)ownerPreferredMinDuration);
        if (expanded.size() > 0) {
            Iterator expandedIterator = expanded.iterator();
            while (expandedIterator.hasNext()) {
                AvailableBlock block = (AvailableBlock)expandedIterator.next();
                if (!block.getStartTime().equals(truncatedStart) || !owner.getPreferredMeetingDurations().isDoubleLength() || !expandedIterator.hasNext()) continue;
                AvailableBlock nextBlock = (AvailableBlock)expandedIterator.next();
                AvailableBlock combined = AvailableBlockBuilder.createBlock((Date)block.getStartTime(), (Date)nextBlock.getEndTime(), (int)block.getVisitorLimit(), (String)block.getMeetingLocation());
                return combined;
            }
        }
        return null;
    }

    @Override
    @Transactional
    public int purgeExpiredBlocks(Integer daysPrior) {
        String propertyValue = System.getProperty("org.jasig.schedassist.runScheduledTasks", "true");
        if (Boolean.parseBoolean(propertyValue)) {
            Date priorTo = DateUtils.truncate((Date)DateUtils.addDays((Date)new Date(), (int)(-daysPrior.intValue())), (int)5);
            int rowCount = this.simpleJdbcTemplate.update("delete from schedules where end_time < ?", new Object[]{priorTo});
            this.LOG.warn((Object)("purged " + rowCount + " rows from schedules table with end_time values prior to: " + priorTo));
            return rowCount;
        }
        this.LOG.debug((Object)"ignoring purgeExpiredBlocks as 'org.jasig.schedassist.runScheduledTasks' set to false");
        return 0;
    }

    protected int internalStoreBlock(PersistenceAvailableBlock scheduleBlock) {
        try {
            return this.simpleJdbcTemplate.update("insert into schedules (owner_id, start_time, end_time, visitor_limit, meeting_location) values (?, ?, ?, ?, ?)", new Object[]{scheduleBlock.getOwnerId(), scheduleBlock.getStartTime(), scheduleBlock.getEndTime(), scheduleBlock.getVisitorLimit(), scheduleBlock.getMeetingLocation()});
        }
        catch (DataIntegrityViolationException e) {
            this.LOG.warn((Object)"ignoring attempt to insert duplicate row", (Throwable)e);
            return 0;
        }
    }

    protected void internalStoreBlocks(Set<PersistenceAvailableBlock> blocks) {
        SqlParameterSource[] batch = SqlParameterSourceUtils.createBatch((Object[])blocks.toArray());
        this.simpleJdbcTemplate.batchUpdate("insert into schedules (owner_id, start_time, end_time, visitor_limit, meeting_location) values (:ownerId, :startTime, :endTime, :visitorLimit, :meetingLocation)", batch);
    }

    protected SortedSet<AvailableBlock> internalRetrieveSchedule(IScheduleOwner owner) {
        List scheduleRows = this.simpleJdbcTemplate.query("select * from schedules where owner_id = ?", (RowMapper)new PersistenceAvailableBlockRowMapper(), new Object[]{owner.getId()});
        TreeSet<AvailableBlock> availableBlocks = new TreeSet<AvailableBlock>();
        for (PersistenceAvailableBlock row : scheduleRows) {
            availableBlocks.add(AvailableBlockBuilder.createBlock((Date)row.getStartTime(), (Date)row.getEndTime(), (int)row.getVisitorLimit(), (String)row.getMeetingLocation()));
        }
        return availableBlocks;
    }

    protected SortedSet<AvailableBlock> internalRetrieveSchedule(IScheduleOwner owner, Date startDate, Date endDate) {
        TreeSet<AvailableBlock> allStoredBlocks = new TreeSet<AvailableBlock>();
        allStoredBlocks.addAll(this.internalRetrieveSchedule(owner));
        TreeSet<AvailableBlock> expanded = new TreeSet<AvailableBlock>();
        expanded.addAll(AvailableBlockBuilder.expand(allStoredBlocks, (int)1));
        AvailableBlock startBlock = AvailableBlockBuilder.createSmallestAllowedBlock((Date)startDate);
        AvailableBlock endBlock = AvailableBlockBuilder.createBlockEndsAt((Date)endDate, (int)1);
        NavigableSet<AvailableBlock> innerSet = expanded.subSet(startBlock, true, endBlock, true);
        SortedSet combinedInnerSet = AvailableBlockBuilder.combine(innerSet);
        return combinedInnerSet;
    }

    private void replaceSchedule(IScheduleOwner owner, SortedSet<AvailableBlock> blocks) {
        this.LOG.debug((Object)("replacing schedule for owner " + owner + "; argument contains " + blocks.size() + " blocks"));
        int rowsUpdated = this.simpleJdbcTemplate.update("delete from schedules where owner_id = ?", new Object[]{owner.getId()});
        this.LOG.debug((Object)("deleted " + rowsUpdated + " for owner " + owner.getId()));
        SortedSet combined = AvailableBlockBuilder.combine(blocks);
        this.LOG.debug((Object)("combined set for owner contains " + combined.size() + " blocks"));
        HashSet<PersistenceAvailableBlock> persistenceBlocks = new HashSet<PersistenceAvailableBlock>();
        for (AvailableBlock newBlock : combined) {
            PersistenceAvailableBlock p = new PersistenceAvailableBlock(newBlock, owner.getId());
            persistenceBlocks.add(p);
        }
        this.internalStoreBlocks(persistenceBlocks);
        this.LOG.warn((Object)("schedule replaced for owner " + owner));
        if (null != this.applicationEventPublisher) {
            AvailableScheduleChangedEvent e = new AvailableScheduleChangedEvent(new AvailableSchedule(blocks), owner);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)e);
        }
    }
}

