/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.owner;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.ICalendarAccountDao;
import org.jasig.schedassist.impl.owner.DefaultScheduleOwnerImpl;
import org.jasig.schedassist.impl.owner.IneligibleException;
import org.jasig.schedassist.impl.owner.OwnerAuthorization;
import org.jasig.schedassist.impl.owner.OwnerDao;
import org.jasig.schedassist.impl.owner.OwnerDefinedRelationship;
import org.jasig.schedassist.impl.owner.OwnerDefinedRelationshipRowMapper;
import org.jasig.schedassist.impl.owner.PersistencePreference;
import org.jasig.schedassist.impl.owner.PersistencePreferenceRowMapper;
import org.jasig.schedassist.impl.owner.PersistenceScheduleOwner;
import org.jasig.schedassist.impl.owner.PersistenceScheduleOwnerRowMapper;
import org.jasig.schedassist.impl.owner.ScheduleOwnerUpdateFailureException;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.Preferences;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="ownerDao")
public class SpringJDBCOwnerDaoImpl
implements OwnerDao {
    private Log LOG = LogFactory.getLog(this.getClass());
    private SimpleJdbcTemplate simpleJdbcTemplate;
    private DataFieldMaxValueIncrementer ownerIdSequence;
    private OwnerAuthorization ownerAuthorization;
    private ICalendarAccountDao calendarAccountDao;

    @Autowired
    public void setDataSource(DataSource dataSource) {
        this.simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    @Autowired
    public void setOwnerIdSequence(@Qualifier(value="owners") DataFieldMaxValueIncrementer ownerIdSequence) {
        this.ownerIdSequence = ownerIdSequence;
    }

    @Autowired
    public void setOwnerAuthorization(OwnerAuthorization ownerAuthorization) {
        this.ownerAuthorization = ownerAuthorization;
    }

    @Autowired
    public void setCalendarAccountDao(@Qualifier(value="composite") ICalendarAccountDao calendarAccountDao) {
        this.calendarAccountDao = calendarAccountDao;
    }

    @Override
    @Transactional
    public IScheduleOwner register(ICalendarAccount calendarAccount) throws IneligibleException {
        Validate.notNull((Object)calendarAccount, (String)"ICalendarAccount argument cannot be null");
        if (!this.ownerAuthorization.isEligible(calendarAccount)) {
            throw new IneligibleException("user is not eligible for owner role: " + calendarAccount);
        }
        IScheduleOwner internal = this.internalLookup(calendarAccount);
        if (null == internal) {
            IScheduleOwner newOwner = this.internalStoreAsOwner(calendarAccount);
            return newOwner;
        }
        return internal;
    }

    @Override
    @Transactional
    public void removeAccount(IScheduleOwner owner) {
        Validate.notNull((Object)owner, (String)"IScheduleOwner argument cannot be null");
        this.simpleJdbcTemplate.update("delete from owner_adhoc_authz where owner_username = ?", new Object[]{owner.getCalendarAccount().getUsername()});
        this.simpleJdbcTemplate.update("delete from owners where internal_id = ?", new Object[]{owner.getId()});
        this.LOG.warn((Object)("removed owner: " + owner));
    }

    @Override
    @Transactional
    public IScheduleOwner locateOwner(ICalendarAccount calendarAccount) {
        Validate.notNull((Object)calendarAccount, (String)"ICalendarAccount argument cannot be null");
        IScheduleOwner owner = this.internalLookup(calendarAccount);
        return owner;
    }

    @Override
    @Transactional
    public IScheduleOwner updatePreference(IScheduleOwner owner, Preferences preference, String value) {
        Validate.notNull((Object)owner, (String)"IScheduleOwner argument cannot be null");
        this.replacePreference(owner, preference, value);
        IScheduleOwner stored = this.internalLookup(owner.getCalendarAccount());
        return stored;
    }

    @Override
    public String retreivePreference(IScheduleOwner owner, Preferences preference) {
        Validate.notNull((Object)owner, (String)"IScheduleOwner argument cannot be null");
        Map<Preferences, String> prefs = this.retrievePreferences(owner);
        return prefs.get(preference);
    }

    @Override
    public Map<Preferences, String> retrievePreferences(IScheduleOwner owner) {
        Validate.notNull((Object)owner, (String)"IScheduleOwner argument cannot be null");
        List stored = this.simpleJdbcTemplate.query("select * from preferences where owner_id = ?", (RowMapper)new PersistencePreferenceRowMapper(), new Object[]{owner.getId()});
        HashMap<Preferences, String> results = new HashMap<Preferences, String>();
        for (PersistencePreference single : stored) {
            Preferences pref = Preferences.fromKey((String)single.getPreferenceKey());
            if (null == pref) {
                this.LOG.debug((Object)("no matching preference for " + single));
                continue;
            }
            results.put(pref, single.getPreferenceValue());
        }
        for (Preferences preference : Preferences.values()) {
            if (null != results.get(preference)) continue;
            results.put(preference, preference.getDefaultValue());
        }
        return results;
    }

    @Override
    @Transactional
    public IScheduleOwner removePreference(IScheduleOwner owner, Preferences preference) {
        Validate.notNull((Object)owner, (String)"IScheduleOwner argument cannot be null");
        int rowsUpdated = this.simpleJdbcTemplate.update("delete from preferences where owner_id = ? and preference_key = ?", new Object[]{owner.getId(), preference.getKey()});
        this.LOG.info((Object)("deleted preference " + preference.getKey() + " for owner " + owner.getId() + ", rowsUpdated: " + rowsUpdated));
        IScheduleOwner stored = this.internalLookup(owner.getCalendarAccount());
        return stored;
    }

    @Override
    public String lookupUniqueId(long id) {
        List uniqueIdResults = this.simpleJdbcTemplate.query("select external_unique_id from owners where internal_id = ?", (RowMapper)new SingleColumnRowMapper(), new Object[]{id});
        return (String)DataAccessUtils.singleResult((Collection)uniqueIdResults);
    }

    @Override
    public String lookupUsername(long id) {
        List usernameResults = this.simpleJdbcTemplate.query("select username from owners where internal_id = ?", (RowMapper)new SingleColumnRowMapper(), new Object[]{id});
        return (String)DataAccessUtils.singleResult((Collection)usernameResults);
    }

    @Override
    @Transactional
    public IScheduleOwner locateOwnerByAvailableId(long internalId) {
        IScheduleOwner result = this.internalLookup(internalId);
        return result;
    }

    protected List<OwnerDefinedRelationship> internalRetrieveRelationships(IScheduleOwner owner) {
        List relationships = this.simpleJdbcTemplate.query("select * from owner_adhoc_authz where owner_username = ?", (RowMapper)new OwnerDefinedRelationshipRowMapper(), new Object[]{owner.getCalendarAccount().getUsername()});
        return relationships;
    }

    protected IScheduleOwner internalStoreAsOwner(ICalendarAccount calendarUser) {
        long newOwnerId = this.ownerIdSequence.nextLongValue();
        int rows = this.simpleJdbcTemplate.update("insert into owners (internal_id, external_unique_id, username) values (?, ?, ?)", new Object[]{newOwnerId, calendarUser.getCalendarUniqueId(), calendarUser.getUsername()});
        DefaultScheduleOwnerImpl newOwner = new DefaultScheduleOwnerImpl(calendarUser, newOwnerId);
        this.LOG.info((Object)("stored new owner: " + (Object)((Object)newOwner) + "; rows updated: " + rows));
        return newOwner;
    }

    protected IScheduleOwner internalLookup(ICalendarAccount calendarAccount) {
        String uniqueId = calendarAccount.getCalendarUniqueId();
        String username = calendarAccount.getUsername();
        List matching = this.simpleJdbcTemplate.query("select * from owners where external_unique_id = ? or username = ?", (RowMapper)new PersistenceScheduleOwnerRowMapper(), new Object[]{uniqueId, username});
        PersistenceScheduleOwner internal = (PersistenceScheduleOwner)DataAccessUtils.singleResult((Collection)matching);
        if (null != internal) {
            internal = this.updateScheduleOwnerIfNecessary(calendarAccount, internal);
            DefaultScheduleOwnerImpl owner = new DefaultScheduleOwnerImpl(calendarAccount, internal.getId());
            Map<Preferences, String> prefs = this.retrievePreferences((IScheduleOwner)owner);
            owner.setPreferences(prefs);
            this.LOG.debug((Object)("found owner " + (Object)((Object)owner)));
            return owner;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected PersistenceScheduleOwner updateScheduleOwnerIfNecessary(ICalendarAccount calendarAccount, PersistenceScheduleOwner persisted) {
        if (!persisted.getCalendarUniqueId().equals(calendarAccount.getCalendarUniqueId()) && persisted.getUsername().equals(calendarAccount.getUsername())) {
            this.LOG.warn((Object)("PersistedScheduleOwner(username=" + persisted.getUsername() + ") has different calendarUniqueId than calendarAccount; persisted: " + persisted.getUsername() + ", new value: " + calendarAccount.getUsername()));
            int rows = this.simpleJdbcTemplate.update("update owners set external_unique_id=? where username=?", new Object[]{calendarAccount.getCalendarUniqueId(), calendarAccount.getUsername()});
            persisted.setCalendarUniqueId(calendarAccount.getCalendarUniqueId());
            if (rows == 1) {
                this.LOG.warn((Object)("change to calendarUniqueId persisted for " + persisted));
                return persisted;
            }
            this.LOG.error((Object)("failed to persist calendarUniqueId update for " + calendarAccount + ", rows " + rows));
            throw new ScheduleOwnerUpdateFailureException("failed to persist calendarUniqueId update for " + calendarAccount);
        }
        if (persisted.getUsername().equals(calendarAccount.getUsername())) return persisted;
        if (!persisted.getCalendarUniqueId().equals(calendarAccount.getCalendarUniqueId())) return persisted;
        String oldUsername = persisted.getUsername();
        String newUsername = calendarAccount.getUsername();
        this.LOG.warn((Object)("PersistedScheduleOwner(calendarUniqueId=" + persisted.getCalendarUniqueId() + ") has different username than calendarAccount; persisted: " + oldUsername + ", new value: " + newUsername));
        int rows = this.simpleJdbcTemplate.update("update owners set username=? where external_unique_id=?", new Object[]{newUsername, calendarAccount.getCalendarUniqueId()});
        persisted.setUsername(calendarAccount.getUsername());
        if (rows == 1) {
            this.LOG.warn((Object)("change to username persisted for " + persisted));
            rows = this.simpleJdbcTemplate.update("update owner_adhoc_authz set owner_username=? where owner_username=?", new Object[]{newUsername, oldUsername});
            if (rows <= 0) return persisted;
            this.LOG.warn((Object)("updated " + rows + " rows in owner_adhoc_authz for " + persisted));
            return persisted;
        }
        this.LOG.error((Object)("failed to persist username update for " + calendarAccount + ", rows " + rows));
        throw new ScheduleOwnerUpdateFailureException("failed to persist username update for " + calendarAccount);
    }

    protected IScheduleOwner internalLookup(long internalId) {
        List matching = this.simpleJdbcTemplate.query("select * from owners where internal_id = ?", (RowMapper)new PersistenceScheduleOwnerRowMapper(), new Object[]{internalId});
        PersistenceScheduleOwner internal = (PersistenceScheduleOwner)DataAccessUtils.singleResult((Collection)matching);
        if (null != internal) {
            ICalendarAccount calendarAccount = this.calendarAccountDao.getCalendarAccount(internal.getUsername());
            if (null == calendarAccount) {
                calendarAccount = this.calendarAccountDao.getCalendarAccountFromUniqueId(internal.getCalendarUniqueId());
                if (null != calendarAccount) {
                    internal = this.updateScheduleOwnerIfNecessary(calendarAccount, internal);
                } else {
                    this.LOG.error((Object)("schedule owner record found, but calendarUserDao reports user not found for " + internal));
                    return null;
                }
            }
            DefaultScheduleOwnerImpl owner = new DefaultScheduleOwnerImpl(calendarAccount, internal.getId());
            Map<Preferences, String> prefs = this.retrievePreferences((IScheduleOwner)owner);
            owner.setPreferences(prefs);
            this.LOG.debug((Object)("found owner " + (Object)((Object)owner)));
            return owner;
        }
        return null;
    }

    protected void replacePreference(IScheduleOwner owner, Preferences preference, String value) {
        int rowsUpdated = this.simpleJdbcTemplate.update("delete from preferences where owner_id = ? and preference_key = ?", new Object[]{owner.getId(), preference.getKey()});
        this.LOG.debug((Object)("deleted existing, rowsUpdated: " + rowsUpdated));
        rowsUpdated = this.simpleJdbcTemplate.update("insert into preferences(owner_id, preference_key, preference_value) values (?, ?, ?)", new Object[]{owner.getId(), preference.getKey(), value});
        this.LOG.info((Object)("stored preference " + preference.getKey() + ", value " + value + ", owner " + owner));
    }
}

