/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springmodules.cache.key.CacheKeyGenerator;
import org.springmodules.cache.key.HashCodeCacheKey;
import org.springmodules.cache.key.HashCodeCalculator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeBasedCacheKeyGenerator
implements CacheKeyGenerator {
    private static final Map<String, Object> POSSIBLE_USER_ATTRIBUTE_NAMES_SEED_MAP = Collections.singletonMap("getPossibleUserAttributeNames_seedMap", new Object());
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Set<String> cacheKeyAttributes = null;
    private String defaultAttributeName = null;
    private Set<String> defaultAttributeNameSet = null;

    public Set<String> getCacheKeyAttributes() {
        return this.cacheKeyAttributes;
    }

    public void setCacheKeyAttributes(Set<String> cacheKeyAttributes) {
        this.cacheKeyAttributes = cacheKeyAttributes;
    }

    public String getDefaultAttributeName() {
        return this.defaultAttributeName;
    }

    @Required
    public void setDefaultAttributeName(String defaultAttributeName) {
        Validate.notNull((Object)defaultAttributeName);
        this.defaultAttributeName = defaultAttributeName;
        this.defaultAttributeNameSet = Collections.singleton(this.defaultAttributeName);
    }

    public Serializable generateKey(MethodInvocation methodInvocation) {
        CachableMethod cachableMethod = this.resolveCacheableMethod(methodInvocation);
        Object[] methodArguments = methodInvocation.getArguments();
        Map<String, Object> seed = this.getSeed(methodArguments, cachableMethod);
        int keyHashCode = this.getKeyHash(seed);
        HashCodeCalculator hashCodeCalculator = new HashCodeCalculator();
        hashCodeCalculator.append(keyHashCode);
        long checkSum = hashCodeCalculator.getCheckSum();
        int hashCode = hashCodeCalculator.getHashCode();
        HashCodeCacheKey hashCodeCacheKey = new HashCodeCacheKey(checkSum, hashCode);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Generated cache key '" + hashCodeCacheKey + "' for MethodInvocation='" + methodInvocation + "'"));
        }
        return hashCodeCacheKey;
    }

    protected Map<String, Object> getSeed(Object[] methodArguments, CachableMethod cachableMethod) {
        Map<String, Object> seed;
        switch (cachableMethod) {
            case MULTIVALUED_USER_ATTRIBUTES__MAP: 
            case USER_ATTRIBUTES__MAP: {
                seed = (Map<String, String>)methodArguments[0];
                break;
            }
            case MULTIVALUED_USER_ATTRIBUTES__STR: {
                String uid = (String)methodArguments[0];
                seed = Collections.singletonMap(this.defaultAttributeName, Collections.singletonList(uid));
                break;
            }
            case USER_ATTRIBUTES__STR: {
                String uid = (String)methodArguments[0];
                seed = Collections.singletonMap(this.defaultAttributeName, uid);
                break;
            }
            case POSSIBLE_USER_ATTRIBUTE_NAMES: {
                seed = POSSIBLE_USER_ATTRIBUTE_NAMES_SEED_MAP;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported CachableMethod resolved: '" + (Object)((Object)cachableMethod) + "'");
            }
        }
        return seed;
    }

    protected int getKeyHash(Map<String, Object> seed) {
        Set<String> cacheAttributes = this.cacheKeyAttributes != null ? this.cacheKeyAttributes : this.defaultAttributeNameSet;
        HashMap<String, Object> cacheKey = new HashMap<String, Object>(cacheAttributes.size());
        for (String attr : cacheAttributes) {
            if (!seed.containsKey(attr)) continue;
            cacheKey.put(attr, seed.get(attr));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Generated cache Map " + cacheKey + " from seed Map " + seed));
        }
        return cacheKey.hashCode();
    }

    protected CachableMethod resolveCacheableMethod(MethodInvocation methodInvocation) {
        Method targetMethod = methodInvocation.getMethod();
        Class<?> targetClass = targetMethod.getDeclaringClass();
        for (CachableMethod cachableMethod : CachableMethod.values()) {
            Method cacheableMethod = null;
            try {
                cacheableMethod = targetClass.getMethod(cachableMethod.getName(), cachableMethod.getArgs());
            }
            catch (SecurityException e) {
                this.logger.warn((Object)("Security exception while attempting to if the target class '" + targetClass + "' implements the cachable method '" + (Object)((Object)cachableMethod) + "'"), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                String message = "Taret class '" + targetClass + "' does not implement possible cachable method '" + (Object)((Object)cachableMethod) + "'. Is the advice applied to the correct bean and methods?";
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)message, (Throwable)e);
                }
                this.logger.warn((Object)message);
            }
            if (!targetMethod.equals(cacheableMethod)) continue;
            return cachableMethod;
        }
        throw new IllegalArgumentException("Do not know how to generate a cache for for '" + targetMethod + "' on class '" + targetClass + "'. Is the advice applied to the correct bean and methods?");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CachableMethod {
        MULTIVALUED_USER_ATTRIBUTES__MAP("getMultivaluedUserAttributes", Map.class),
        MULTIVALUED_USER_ATTRIBUTES__STR("getMultivaluedUserAttributes", String.class),
        USER_ATTRIBUTES__MAP("getUserAttributes", Map.class),
        USER_ATTRIBUTES__STR("getUserAttributes", String.class),
        POSSIBLE_USER_ATTRIBUTE_NAMES("getPossibleUserAttributeNames", new Class[0]);

        private final String name;
        private final Class<?>[] args;

        private CachableMethod(String name, Class<?> ... args) {
            this.name = name;
            this.args = args;
        }

        public String getName() {
            return this.name;
        }

        public Class<?>[] getArgs() {
            return this.args;
        }

        public String toString() {
            return this.name + "(" + Arrays.asList(this.args) + ")";
        }
    }
}

