/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support.jdbc;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.lang.Validate;
import org.jasig.services.persondir.support.MultivaluedPersonAttributeUtils;
import org.jasig.services.persondir.support.jdbc.AbstractJdbcPersonAttributeDao;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.BadSqlGrammarException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleRowJdbcPersonAttributeDao
extends AbstractJdbcPersonAttributeDao {
    private Map<String, Set<String>> attributeMappings = Collections.emptyMap();
    private Set<String> userAttributes = Collections.emptySet();

    public SingleRowJdbcPersonAttributeDao(DataSource ds, List<String> attrList, String sql) {
        super(ds, sql);
        this.setQueryAttributes(attrList);
    }

    @Override
    protected Map<String, List<Object>> parseAttributeMapFromResults(List<Map<String, Object>> queryResults) {
        if (queryResults.size() > 1) {
            throw new IncorrectResultSizeDataAccessException(1, queryResults.size());
        }
        HashMap<String, List<Object>> attributeMap = new HashMap<String, List<Object>>();
        for (Map<String, Object> result : queryResults) {
            for (String columnName : this.attributeMappings.keySet()) {
                this.addMappedAttributes(result, columnName, attributeMap);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Returning attribute Map '" + attributeMap + "' from query results '" + queryResults + "'"));
        }
        return attributeMap;
    }

    public Set<String> getPossibleUserAttributeNames() {
        return this.userAttributes;
    }

    protected void addMappedAttributes(Map<String, Object> rs, String columnName, Map<String, List<Object>> rowResults) {
        Validate.notEmpty((String)columnName, (String)"columnName cannot be null and must have length >= 0");
        Object attributeValue = rs.get(columnName);
        if (attributeValue == null && !rs.containsKey(columnName)) {
            throw new BadSqlGrammarException("No column named '" + columnName + "' exists in result set", this.getSql(), null);
        }
        Set<String> attributeNames = this.attributeMappings.get(columnName);
        if (attributeNames == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No mapped attribute name for column='" + columnName + "', defaulting to the column name."));
            }
            attributeNames = Collections.singleton(columnName);
        }
        for (String attributeName : attributeNames) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Adding mapped attribute '" + attributeName + "' for source column '" + columnName + "'"));
            }
            MultivaluedPersonAttributeUtils.addResult(rowResults, attributeName, attributeValue);
        }
    }

    public Map<String, Set<String>> getColumnsToAttributes() {
        return this.attributeMappings;
    }

    public void setColumnsToAttributes(Map<String, Object> columnsToAttributesMap) {
        if (columnsToAttributesMap == null) {
            throw new IllegalArgumentException("columnsToAttributesMap may not be null");
        }
        this.attributeMappings = MultivaluedPersonAttributeUtils.parseAttributeToAttributeMapping(columnsToAttributesMap);
        if (this.attributeMappings.containsKey("")) {
            throw new IllegalArgumentException("The map from attribute names to attributes must not have any empty keys.");
        }
        Collection userAttributeCol = MultivaluedPersonAttributeUtils.flattenCollection(this.attributeMappings.values());
        this.userAttributes = Collections.unmodifiableSet(new HashSet(userAttributeCol));
    }
}

