/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.jasig.services.persondir.IPersonAttributes;
import org.jasig.services.persondir.support.BasePersonAttributeDao;
import org.jasig.services.persondir.support.CaseInsensitiveNamedPersonImpl;
import org.jasig.services.persondir.support.NamedPersonImpl;
import org.springframework.core.io.Resource;

public class GroovyPersonAttributeDao
extends BasePersonAttributeDao {
    private final Resource groovyScriptResource;
    private String groovyScriptExecutingMethodName = "run";
    private boolean caseInsensitiveUsername = false;

    public GroovyPersonAttributeDao(Resource groovyScriptPath) throws IOException {
        this.verifyGroovyScriptAndThrowExceptionIfNeeded(groovyScriptPath);
        this.groovyScriptResource = groovyScriptPath;
    }

    public void setGroovyScriptExecutingMethodName(String methodName) {
        this.groovyScriptExecutingMethodName = methodName;
    }

    public void setCaseInsensitiveUsername(boolean caseInsensitiveUsername) {
        this.caseInsensitiveUsername = caseInsensitiveUsername;
    }

    private void verifyGroovyScriptAndThrowExceptionIfNeeded(Resource groovyScriptPath) throws IOException {
        if (!groovyScriptPath.exists()) {
            throw new RuntimeException("Groovy script cannot be found at the specifiied location: " + groovyScriptPath.getFilename());
        }
        if (groovyScriptPath.isOpen()) {
            throw new RuntimeException("Another process/application is busy with the specified groovy script");
        }
        if (!groovyScriptPath.isReadable()) {
            throw new RuntimeException("Groovy script cannot be read");
        }
        if (groovyScriptPath.contentLength() <= 0L) {
            throw new RuntimeException("Groovy script is empty and has no content");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IPersonAttributes getPerson(String uid) {
        NamedPersonImpl namedPersonImpl;
        Map<String, List<Object>> personAttributes;
        GroovyClassLoader loader;
        block5: {
            loader = null;
            ClassLoader parent = this.getClass().getClassLoader();
            loader = new GroovyClassLoader(parent);
            Class groovyClass = loader.parseClass(this.groovyScriptResource.getFile());
            this.logger.debug((Object)("Loaded groovy class " + groovyClass.getSimpleName() + " from script " + this.groovyScriptResource.getFilename()));
            GroovyObject groovyObject = (GroovyObject)groovyClass.newInstance();
            this.logger.debug((Object)("Created groovy object instance from class " + this.groovyScriptResource.getFilename()));
            Object[] args = new Object[]{uid, this.logger};
            this.logger.debug((Object)("Executing groovy script's " + this.groovyScriptExecutingMethodName + " method, with parameters " + args));
            Map personAttributesMap = (Map)groovyObject.invokeMethod(this.groovyScriptExecutingMethodName, (Object)args);
            this.logger.debug((Object)("Creating person attributes with the username " + uid + " and attributes {}" + personAttributesMap));
            personAttributes = this.stuffAttributesIntoListValues(personAttributesMap);
            if (!this.caseInsensitiveUsername) break block5;
            CaseInsensitiveNamedPersonImpl caseInsensitiveNamedPersonImpl = new CaseInsensitiveNamedPersonImpl(uid, personAttributes);
            IOUtils.closeQuietly((Closeable)loader);
            return caseInsensitiveNamedPersonImpl;
        }
        try {
            namedPersonImpl = new NamedPersonImpl(uid, personAttributes);
        }
        catch (Exception e) {
            try {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(loader);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)loader);
            return null;
        }
        IOUtils.closeQuietly((Closeable)loader);
        return namedPersonImpl;
    }

    private Map<String, List<Object>> stuffAttributesIntoListValues(Map<String, Object> personAttributesMap) {
        HashMap<String, List<Object>> personAttributes = new HashMap<String, List<Object>>();
        for (String key : personAttributesMap.keySet()) {
            Object value = personAttributesMap.get(key);
            if (value instanceof List) {
                personAttributes.put(key, (List)value);
                continue;
            }
            personAttributes.put(key, Arrays.asList(value));
        }
        return personAttributes;
    }

    public Set<IPersonAttributes> getPeople(Map<String, Object> query) {
        return null;
    }

    public Set<IPersonAttributes> getPeopleWithMultivaluedAttributes(Map<String, List<Object>> query) {
        return null;
    }

    public Set<String> getPossibleUserAttributeNames() {
        return null;
    }

    public Set<String> getAvailableQueryAttributes() {
        return null;
    }
}

