/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support.jdbc;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;
import org.jasig.services.persondir.support.AbstractQueryPersonAttributeDao;
import org.jasig.services.persondir.support.QueryType;
import org.jasig.services.persondir.support.jdbc.PartialWhereClause;
import org.jasig.services.persondir.util.CaseCanonicalizationMode;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;

public abstract class AbstractJdbcPersonAttributeDao<R>
extends AbstractQueryPersonAttributeDao<PartialWhereClause> {
    private static final Pattern WHERE_PLACEHOLDER = Pattern.compile("\\{0\\}");
    private static final Map<CaseCanonicalizationMode, MessageFormat> DEFAULT_DATA_ATTRIBUTE_CASE_CANONICALIZATION_FUNCTIONS = Collections.unmodifiableMap(new LinkedHashMap<CaseCanonicalizationMode, MessageFormat>(){
        {
            this.put(CaseCanonicalizationMode.LOWER, new MessageFormat("lower({0})"));
            this.put(CaseCanonicalizationMode.UPPER, new MessageFormat("upper({0})"));
            this.put(CaseCanonicalizationMode.NONE, new MessageFormat("{0}"));
        }
    });
    private final JdbcTemplate simpleJdbcTemplate;
    private final String queryTemplate;
    private QueryType queryType = QueryType.AND;
    private Map<String, CaseCanonicalizationMode> caseInsensitiveDataAttributes;
    private Map<CaseCanonicalizationMode, MessageFormat> dataAttributeCaseCanonicalizationFunctions = DEFAULT_DATA_ATTRIBUTE_CASE_CANONICALIZATION_FUNCTIONS;

    public AbstractJdbcPersonAttributeDao(DataSource ds, String queryTemplate) {
        Validate.notNull((Object)ds, (String)"DataSource can not be null", (Object[])new Object[0]);
        Validate.notNull((Object)queryTemplate, (String)"queryTemplate can not be null", (Object[])new Object[0]);
        this.simpleJdbcTemplate = new JdbcTemplate(ds);
        this.queryTemplate = queryTemplate;
    }

    public String getQueryTemplate() {
        return this.queryTemplate;
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    public void setQueryType(QueryType queryType) {
        this.queryType = queryType;
    }

    protected abstract List<IPersonAttributes> parseAttributeMapFromResults(List<R> var1, String var2);

    protected abstract ParameterizedRowMapper<R> getRowMapper();

    @Override
    protected PartialWhereClause appendAttributeToQuery(PartialWhereClause queryBuilder, String dataAttribute, List<Object> queryValues) {
        for (Object queryValue : queryValues) {
            String queryString = queryValue != null ? queryValue.toString() : null;
            if (!StringUtils.isNotBlank((CharSequence)queryString)) continue;
            if (queryBuilder == null) {
                queryBuilder = new PartialWhereClause();
            } else if (queryBuilder.sql.length() > 0) {
                queryBuilder.sql.append(" ").append(this.queryType.toString()).append(" ");
            }
            Matcher queryValueMatcher = IPersonAttributeDao.WILDCARD_PATTERN.matcher(queryString);
            String formattedQueryValue = queryValueMatcher.replaceAll("%");
            queryBuilder.arguments.add(formattedQueryValue);
            if (dataAttribute != null) {
                dataAttribute = this.canonicalizeDataAttributeForSql(dataAttribute);
                queryBuilder.sql.append(dataAttribute);
                if (formattedQueryValue.equals(queryString)) {
                    queryBuilder.sql.append(" = ");
                } else {
                    queryBuilder.sql.append(" LIKE ");
                }
            }
            queryBuilder.sql.append("?");
        }
        return queryBuilder;
    }

    protected String canonicalizeDataAttributeForSql(String dataAttribute) {
        MessageFormat mf;
        if (this.caseInsensitiveDataAttributes == null || this.caseInsensitiveDataAttributes.isEmpty() || !this.caseInsensitiveDataAttributes.containsKey(dataAttribute)) {
            return dataAttribute;
        }
        if (this.dataAttributeCaseCanonicalizationFunctions == null || this.dataAttributeCaseCanonicalizationFunctions.isEmpty()) {
            return dataAttribute;
        }
        CaseCanonicalizationMode canonicalizationMode = this.caseInsensitiveDataAttributes.get(dataAttribute);
        if (canonicalizationMode == null) {
            canonicalizationMode = this.getDefaultCaseCanonicalizationMode();
        }
        if ((mf = this.dataAttributeCaseCanonicalizationFunctions.get((Object)canonicalizationMode)) == null) {
            return dataAttribute;
        }
        return mf.format(new String[]{dataAttribute});
    }

    @Override
    protected List<IPersonAttributes> getPeopleForQuery(PartialWhereClause queryBuilder, String queryUserName) {
        List results;
        ParameterizedRowMapper<R> rowMapper = this.getRowMapper();
        if (queryBuilder != null) {
            StringBuilder partialSqlWhere = queryBuilder.sql;
            Matcher queryMatcher = WHERE_PLACEHOLDER.matcher(this.queryTemplate);
            String querySQL = queryMatcher.replaceAll(partialSqlWhere.toString());
            results = this.simpleJdbcTemplate.query(querySQL, rowMapper, queryBuilder.arguments.toArray());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Executed '" + this.queryTemplate + "' with arguments " + queryBuilder.arguments + " and got results " + results));
            }
        } else {
            results = this.simpleJdbcTemplate.query(this.queryTemplate, rowMapper);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Executed '" + this.queryTemplate + "' and got results " + results));
            }
        }
        return this.parseAttributeMapFromResults(results, queryUserName);
    }

    public Map<String, CaseCanonicalizationMode> getCaseInsensitiveDataAttributes() {
        return this.caseInsensitiveDataAttributes;
    }

    public void setCaseInsensitiveDataAttributes(Map<String, CaseCanonicalizationMode> caseInsensitiveDataAttributes) {
        this.caseInsensitiveDataAttributes = caseInsensitiveDataAttributes;
    }

    public void setCaseInsensitiveDataAttributesAsCollection(Collection<String> caseInsensitiveDataAttributes) {
        if (caseInsensitiveDataAttributes == null || caseInsensitiveDataAttributes.isEmpty()) {
            this.setCaseInsensitiveDataAttributes(null);
        } else {
            HashMap<String, CaseCanonicalizationMode> asMap = new HashMap<String, CaseCanonicalizationMode>();
            for (String attrib : caseInsensitiveDataAttributes) {
                asMap.put(attrib, null);
            }
            this.setCaseInsensitiveDataAttributes(asMap);
        }
    }

    public void setDataAttributeCaseCanonicalizationFunctions(Map<CaseCanonicalizationMode, MessageFormat> dataAttributeCaseCanonicalizationFunctions) {
        this.dataAttributeCaseCanonicalizationFunctions = dataAttributeCaseCanonicalizationFunctions;
    }

    public Map<CaseCanonicalizationMode, MessageFormat> getDataAttributeCaseCanonicalizationFunctions() {
        return this.dataAttributeCaseCanonicalizationFunctions;
    }
}

