/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support.rule;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jasig.services.persondir.IPersonAttributes;
import org.jasig.services.persondir.support.NamedPersonImpl;
import org.jasig.services.persondir.support.rule.AttributeRule;

public final class SimpleAttributeRule
implements AttributeRule {
    private final String whenKey;
    private final String whenPattern;
    private final String setUserName;
    private final String setKey;
    private final String setValue;
    private final Set<String> possibleAttributeNames;

    public SimpleAttributeRule() {
        this.whenKey = null;
        this.whenPattern = null;
        this.setUserName = null;
        this.setKey = null;
        this.setValue = null;
        this.possibleAttributeNames = new HashSet<String>();
    }

    public SimpleAttributeRule(String whenKey, String whenPattern, String setUserName, String setKey, String setValue) {
        if (whenKey == null) {
            String msg = "Argument 'whenKey' cannot be null.";
            throw new IllegalArgumentException("Argument 'whenKey' cannot be null.");
        }
        if (whenPattern == null) {
            String msg = "Argument 'whenPattern' cannot be null.";
            throw new IllegalArgumentException("Argument 'whenPattern' cannot be null.");
        }
        if (setKey == null) {
            String msg = "Argument 'setKey' cannot be null.";
            throw new IllegalArgumentException("Argument 'setKey' cannot be null.");
        }
        if (setUserName == null) {
            String msg = "Argument 'setUserName' cannot be null.";
            throw new IllegalArgumentException("Argument 'setUserName' cannot be null.");
        }
        if (setValue == null) {
            String msg = "Argument 'setValue' cannot be null.";
            throw new IllegalArgumentException("Argument 'setValue' cannot be null.");
        }
        this.whenKey = whenKey;
        this.whenPattern = whenPattern;
        this.setUserName = setUserName;
        this.setKey = setKey;
        this.setValue = setValue;
        HashSet<String> list = new HashSet<String>();
        list.add(this.setKey);
        this.possibleAttributeNames = list;
    }

    @Override
    public boolean appliesTo(Map<String, List<Object>> userInfo) {
        if (userInfo == null) {
            String msg = "Argument 'userInfo' cannot be null.";
            throw new IllegalArgumentException("Argument 'userInfo' cannot be null.");
        }
        List<Object> value = userInfo.get(this.whenKey);
        if (value == null) {
            return false;
        }
        String[] compare = null;
        try {
            compare = value.toArray(new String[value.size()]);
        }
        catch (ClassCastException cce) {
            String msg = "List values may contain only String instances.";
            throw new RuntimeException("List values may contain only String instances.", cce);
        }
        boolean rslt = false;
        for (int i = 0; i < compare.length; ++i) {
            if (!compare[i].matches(this.whenPattern)) continue;
            rslt = true;
            break;
        }
        return rslt;
    }

    @Override
    public Set<IPersonAttributes> evaluate(Map<String, List<Object>> userInfo) {
        if (userInfo == null) {
            String msg = "Argument 'userInfo' cannot be null.";
            throw new IllegalArgumentException("Argument 'userInfo' cannot be null.");
        }
        if (!this.appliesTo(userInfo)) {
            String msg = "May not evaluate.  This rule does not apply.";
            throw new IllegalArgumentException("May not evaluate.  This rule does not apply.");
        }
        LinkedHashMap<String, List<Object>> rslt = new LinkedHashMap<String, List<Object>>();
        ArrayList<String> value = new ArrayList<String>(1);
        value.add(this.setValue);
        rslt.put(this.setKey, value);
        NamedPersonImpl person = new NamedPersonImpl(this.setUserName, rslt);
        return Collections.singleton(person);
    }

    @Override
    @JsonIgnore
    public Set<String> getPossibleUserAttributeNames() {
        return this.possibleAttributeNames;
    }

    @Override
    @JsonIgnore
    public Set<String> getAvailableQueryAttributes() {
        HashSet<String> list = new HashSet<String>();
        list.add(this.whenKey);
        return list;
    }
}

