/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.spring.webflow.plugin;

import java.io.IOException;
import java.io.Serializable;
import org.jasig.spring.webflow.plugin.ClientFlowExecutionKey;
import org.jasig.spring.webflow.plugin.ClientFlowExecutionRepositoryException;
import org.jasig.spring.webflow.plugin.Transcoder;
import org.springframework.util.Assert;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionLocator;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionFactory;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.FlowExecutionKeyFactory;
import org.springframework.webflow.execution.repository.FlowExecutionLock;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.execution.repository.FlowExecutionRepositoryException;

public class ClientFlowExecutionRepository
implements FlowExecutionRepository,
FlowExecutionKeyFactory {
    private static final FlowExecutionLock NOOP_LOCK = new FlowExecutionLock(){

        public void lock() {
        }

        public void unlock() {
        }
    };
    private final FlowExecutionFactory flowExecutionFactory;
    private final FlowDefinitionLocator flowDefinitionLocator;
    private final Transcoder transcoder;

    public ClientFlowExecutionRepository(FlowExecutionFactory flowExecutionFactory, FlowDefinitionLocator flowDefinitionLocator, Transcoder transcoder) {
        Assert.notNull((Object)flowExecutionFactory, (String)"FlowExecutionFactory cannot be null");
        Assert.notNull((Object)flowDefinitionLocator, (String)"FlowDefinitionLocator cannot be null");
        Assert.notNull((Object)transcoder, (String)"Transcoder cannot be null");
        this.flowExecutionFactory = flowExecutionFactory;
        this.flowDefinitionLocator = flowDefinitionLocator;
        this.transcoder = transcoder;
    }

    public FlowExecutionKey parseFlowExecutionKey(String encodedKey) throws FlowExecutionRepositoryException {
        return ClientFlowExecutionKey.parse(encodedKey);
    }

    public FlowExecutionLock getLock(FlowExecutionKey key) throws FlowExecutionRepositoryException {
        return NOOP_LOCK;
    }

    public FlowExecution getFlowExecution(FlowExecutionKey key) throws FlowExecutionRepositoryException {
        if (!(key instanceof ClientFlowExecutionKey)) {
            throw new IllegalArgumentException("Expected instance of ClientFlowExecutionKey but got " + key.getClass().getName());
        }
        byte[] encoded = ((ClientFlowExecutionKey)key).getData();
        try {
            SerializedFlowExecutionState state = (SerializedFlowExecutionState)this.transcoder.decode(encoded);
            FlowDefinition flow = this.flowDefinitionLocator.getFlowDefinition(state.getFlowId());
            return this.flowExecutionFactory.restoreFlowExecution(state.getExecution(), flow, key, state.getConversationScope(), this.flowDefinitionLocator);
        }
        catch (IOException e) {
            throw new ClientFlowExecutionRepositoryException("Error decoding flow execution", e);
        }
    }

    public void putFlowExecution(FlowExecution flowExecution) throws FlowExecutionRepositoryException {
    }

    public void removeFlowExecution(FlowExecution flowExecution) throws FlowExecutionRepositoryException {
    }

    public FlowExecutionKey getKey(FlowExecution execution) {
        try {
            return new ClientFlowExecutionKey(this.transcoder.encode(new SerializedFlowExecutionState(execution)));
        }
        catch (IOException e) {
            throw new ClientFlowExecutionRepositoryException("Error encoding flow execution", e);
        }
    }

    public void updateFlowExecutionSnapshot(FlowExecution execution) {
    }

    public void removeFlowExecutionSnapshot(FlowExecution execution) {
    }

    public void removeAllFlowExecutionSnapshots(FlowExecution execution) {
    }

    private static class SerializedFlowExecutionState
    implements Serializable {
        private static final long serialVersionUID = -4020991769174829876L;
        private final String flowId;
        private final MutableAttributeMap conversationScope;
        private final FlowExecution execution;

        public SerializedFlowExecutionState(FlowExecution execution) {
            this.execution = execution;
            this.flowId = execution.getDefinition().getId();
            this.conversationScope = execution.getConversationScope();
        }

        public String getFlowId() {
            return this.flowId;
        }

        public MutableAttributeMap getConversationScope() {
            return this.conversationScope;
        }

        public FlowExecution getExecution() {
            return this.execution;
        }
    }
}

