/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.spring3.xml.encryption;

import org.jasypt.spring3.xml.encryption.AbstractEncryptionBeanDefinitionParser;
import org.jasypt.util.text.BasicTextEncryptor;
import org.jasypt.util.text.StrongTextEncryptor;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

final class UtilEncryptorBeanDefinitionParser
extends AbstractEncryptionBeanDefinitionParser {
    private static final String SCOPE_ATTRIBUTE = "scope";
    private static final String PARAM_PASSWORD = "password";
    static final int UTIL_TYPE_BASIC = 0;
    static final int UTIL_TYPE_STRONG = 1;
    private final int utilType;

    UtilEncryptorBeanDefinitionParser(int utilType) {
        this.utilType = utilType;
    }

    protected Class<?> getBeanClass(Element element) {
        if (this.utilType == 0) {
            return BasicTextEncryptor.class;
        }
        if (this.utilType == 1) {
            return StrongTextEncryptor.class;
        }
        throw new IllegalArgumentException("Unknown util type: " + this.utilType);
    }

    protected void doParse(Element element, BeanDefinitionBuilder builder) {
        this.processStringAttribute(element, builder, PARAM_PASSWORD, PARAM_PASSWORD);
        String scope = element.getAttribute(SCOPE_ATTRIBUTE);
        if (StringUtils.hasLength((String)scope)) {
            builder.setScope(scope);
        }
    }
}

