/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javalite.activejdbc.AbstractLazyList;
import org.javalite.activejdbc.Association;
import org.javalite.activejdbc.DB;
import org.javalite.activejdbc.DBException;
import org.javalite.activejdbc.MetaModel;
import org.javalite.activejdbc.Model;
import org.javalite.activejdbc.ModelDelegate;
import org.javalite.activejdbc.RowListenerAdapter;
import org.javalite.activejdbc.SuperLazyList;
import org.javalite.activejdbc.associations.BelongsToAssociation;
import org.javalite.activejdbc.associations.BelongsToPolymorphicAssociation;
import org.javalite.activejdbc.associations.Many2ManyAssociation;
import org.javalite.activejdbc.associations.OneToManyAssociation;
import org.javalite.activejdbc.associations.OneToManyPolymorphicAssociation;
import org.javalite.activejdbc.cache.QueryCache;
import org.javalite.activejdbc.logging.LogFilter;
import org.javalite.common.Inflector;
import org.javalite.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyList<T extends Model>
extends AbstractLazyList<T>
implements Externalizable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LazyList.class);
    private final List<String> orderBys = new ArrayList<String>();
    private final MetaModel metaModel;
    private final String subQuery;
    private final String fullQuery;
    private final Object[] params;
    private long limit = -1L;
    private long offset = -1L;
    private final List<Association> includes = new ArrayList<Association>();
    private final boolean forPaginator;

    protected LazyList(String subQuery, MetaModel metaModel, Object ... params) {
        this.fullQuery = null;
        this.subQuery = subQuery;
        this.params = params == null ? new Object[]{} : params;
        this.metaModel = metaModel;
        this.forPaginator = false;
    }

    protected LazyList(boolean forPaginator, MetaModel metaModel, String fullQuery, Object ... params) {
        this.fullQuery = fullQuery;
        this.subQuery = null;
        this.params = params == null ? new Object[]{} : params;
        this.metaModel = metaModel;
        this.forPaginator = forPaginator;
    }

    protected LazyList() {
        this.delegate = new ArrayList();
        this.fullQuery = null;
        this.subQuery = null;
        this.params = null;
        this.metaModel = null;
        this.forPaginator = false;
    }

    public <E extends Model> LazyList<E> limit(long limit) {
        if (this.fullQuery != null && !this.forPaginator) {
            throw new IllegalArgumentException("Cannot use .limit() if using free form SQL");
        }
        if (limit < 0L) {
            throw new IllegalArgumentException("limit cannot be negative");
        }
        this.limit = limit;
        return this;
    }

    public <E extends Model> LazyList<E> offset(long offset) {
        if (this.fullQuery != null && !this.forPaginator) {
            throw new IllegalArgumentException("Cannot use .offset() if using free form SQL");
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("offset cannot be negative");
        }
        this.offset = offset;
        return this;
    }

    public <E extends Model> LazyList<E> orderBy(String orderBy) {
        if (this.fullQuery != null && !this.forPaginator) {
            throw new IllegalArgumentException("Cannot use .orderBy() if using free form SQL");
        }
        this.orderBys.add(orderBy);
        return this;
    }

    public <E extends Model> LazyList<E> include(Class<? extends Model> ... classes) {
        if (!this.includes.isEmpty()) {
            throw new IllegalArgumentException("Can't call include() more than once!");
        }
        for (Class<? extends Model> clazz : classes) {
            if (this.metaModel.isAssociatedTo(clazz)) continue;
            throw new IllegalArgumentException("Model: " + clazz.getName() + " is not associated with: " + this.metaModel.getModelClass().getName());
        }
        for (Class<? extends Model> includeClass : classes) {
            this.includes.addAll(this.metaModel.getAssociationsForTarget(includeClass));
        }
        return this;
    }

    public List<Map<String, Object>> toMaps() {
        this.hydrate();
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>(this.delegate.size());
        for (Model t : this.delegate) {
            maps.add(t.toMap());
        }
        return maps;
    }

    public String toXml(boolean pretty, boolean declaration, String ... attrs) {
        String topNode = Inflector.pluralize((String)Inflector.underscore((String)this.metaModel.getModelClass().getSimpleName()));
        this.hydrate();
        StringBuilder sb = new StringBuilder();
        if (declaration) {
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            if (pretty) {
                sb.append('\n');
            }
        }
        sb.append('<').append(topNode).append('>');
        if (pretty) {
            sb.append('\n');
        }
        for (Model t : this.delegate) {
            t.toXmlP(sb, pretty, pretty ? "  " : "", attrs);
        }
        sb.append("</").append(topNode).append('>');
        if (pretty) {
            sb.append('\n');
        }
        return sb.toString();
    }

    @Deprecated
    public String toXml(int spaces, boolean declaration, String ... attrs) {
        return this.toXml(spaces > 0, declaration, attrs);
    }

    public String toJson(boolean pretty, String ... attrs) {
        this.hydrate();
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        if (pretty) {
            sb.append('\n');
        }
        for (int i = 0; i < this.delegate.size(); ++i) {
            if (i > 0) {
                sb.append(',');
                if (pretty) {
                    sb.append('\n');
                }
            }
            ((Model)this.delegate.get(i)).toJsonP(sb, pretty, pretty ? "  " : "", attrs);
        }
        if (pretty) {
            sb.append('\n');
        }
        sb.append(']');
        return sb.toString();
    }

    public <E extends Model> LazyList<E> load() {
        if (this.hydrated()) {
            throw new DBException("load() must be the last on the chain of methods");
        }
        this.hydrate();
        return this;
    }

    public String toSql() {
        return this.toSql(true);
    }

    public String toSql(boolean showParameters) {
        String sql;
        if (this.forPaginator) {
            sql = this.metaModel.getDialect().formSelect(null, null, this.fullQuery, this.orderBys, this.limit, this.offset);
        } else {
            String string = sql = this.fullQuery != null ? this.fullQuery : this.metaModel.getDialect().formSelect(this.metaModel.getTableName(), null, this.subQuery, this.orderBys, this.limit, this.offset);
        }
        if (showParameters) {
            StringBuilder sb = new StringBuilder(sql).append(", with parameters: ");
            Util.join((StringBuilder)sb, (Object[])this.params, (String)", ");
            sql = sb.toString();
        }
        return sql;
    }

    @Override
    protected void hydrate() {
        List cached;
        if (this.hydrated()) {
            return;
        }
        String sql = this.toSql(false);
        if (this.metaModel.cached() && (cached = (List)QueryCache.instance().getItem(this.metaModel.getTableName(), sql, this.params)) != null) {
            this.delegate = cached;
            LogFilter.logQuery(LOGGER, sql, this.params, System.currentTimeMillis(), true);
            return;
        }
        this.delegate = new ArrayList();
        long start = System.currentTimeMillis();
        new DB(this.metaModel.getDbName()).find(sql, this.params).with(new RowListenerAdapter(){

            @Override
            public void onNext(Map<String, Object> map) {
                LazyList.this.delegate.add(ModelDelegate.instance(map, LazyList.this.metaModel));
            }
        });
        LogFilter.logQuery(LOGGER, sql, this.params, start, false);
        if (this.metaModel.cached()) {
            this.delegate = Collections.unmodifiableList(this.delegate);
            QueryCache.instance().addItem(this.metaModel.getTableName(), sql, this.params, this.delegate);
        }
        this.processIncludes();
    }

    private boolean hydrated() {
        return this.delegate != null;
    }

    private void processIncludes() {
        for (Association association : this.includes) {
            if (association instanceof BelongsToAssociation) {
                this.processParent((BelongsToAssociation)association);
                continue;
            }
            if (association instanceof OneToManyAssociation) {
                this.processChildren((OneToManyAssociation)association);
                continue;
            }
            if (association instanceof Many2ManyAssociation) {
                this.processManyToMany((Many2ManyAssociation)association);
                continue;
            }
            if (association instanceof OneToManyPolymorphicAssociation) {
                this.processPolymorphicChildren((OneToManyPolymorphicAssociation)association);
                continue;
            }
            if (!(association instanceof BelongsToPolymorphicAssociation)) continue;
            this.processPolymorphicParent((BelongsToPolymorphicAssociation)association);
        }
    }

    private void processPolymorphicParent(BelongsToPolymorphicAssociation association) {
        if (this.delegate.isEmpty()) {
            return;
        }
        Set distinctParentIds = this.collectDistinct("parent_id", "parent_type", association.getParentClassName());
        distinctParentIds.remove(null);
        if (distinctParentIds.isEmpty()) {
            return;
        }
        MetaModel parentMetaModel = ModelDelegate.metaModelOf(association.getTargetClass());
        HashMap<String, Model> parentById = new HashMap<String, Model>();
        StringBuilder query = new StringBuilder().append(parentMetaModel.getIdName()).append(" IN (");
        this.appendQuestions(query, distinctParentIds.size());
        query.append(')');
        for (Model parent : new LazyList<T>(query.toString(), parentMetaModel, distinctParentIds.toArray())) {
            parentById.put(association.getParentClassName() + ":" + parent.getId(), parent);
        }
        for (Model child : this.delegate) {
            child.setCachedParent((Model)parentById.get(association.getParentClassName() + ":" + child.get("parent_id")));
        }
    }

    private void processParent(BelongsToAssociation association) {
        if (this.delegate.isEmpty()) {
            return;
        }
        Set distinctParentIds = this.collectDistinct(association.getFkName());
        distinctParentIds.remove(null);
        if (distinctParentIds.isEmpty()) {
            return;
        }
        MetaModel parentMetaModel = ModelDelegate.metaModelOf(association.getTargetClass());
        HashMap<Object, Model> parentById = new HashMap<Object, Model>();
        StringBuilder query = new StringBuilder().append(parentMetaModel.getIdName()).append(" IN (");
        this.appendQuestions(query, distinctParentIds.size());
        query.append(')');
        for (Model parent : new LazyList<T>(query.toString(), parentMetaModel, distinctParentIds.toArray())) {
            parentById.put(parent.getId(), parent);
        }
        for (Model child : this.delegate) {
            child.setCachedParent((Model)parentById.get(child.get(association.getFkName())));
        }
    }

    public List collect(String attributeName) {
        ArrayList results = new ArrayList();
        this.collect(results, attributeName);
        return results;
    }

    public Set collectDistinct(String attributeName) {
        LinkedHashSet results = new LinkedHashSet();
        this.collect(results, attributeName);
        return results;
    }

    private void collect(Collection results, String attributeName) {
        this.hydrate();
        for (Model model : this.delegate) {
            results.add(model.get(attributeName));
        }
    }

    public List collect(String attributeName, String filterAttribute, Object filterValue) {
        ArrayList results = new ArrayList();
        this.collect(results, attributeName, filterAttribute, filterValue);
        return results;
    }

    public Set collectDistinct(String attributeName, String filterAttribute, Object filterValue) {
        LinkedHashSet results = new LinkedHashSet();
        this.collect(results, attributeName, filterAttribute, filterValue);
        return results;
    }

    private void collect(Collection results, String attributeName, String filterAttribute, Object filterValue) {
        this.hydrate();
        for (Model model : this.delegate) {
            if (!model.get(filterAttribute).equals(filterValue)) continue;
            results.add(model.get(attributeName));
        }
    }

    private void appendQuestions(StringBuilder sb, int count) {
        Util.joinAndRepeat((StringBuilder)sb, (String)"?", (String)", ", (int)count);
    }

    private void processPolymorphicChildren(OneToManyPolymorphicAssociation association) {
        if (this.delegate.isEmpty()) {
            return;
        }
        MetaModel childMetaModel = ModelDelegate.metaModelOf(association.getTargetClass());
        HashMap childrenByParentId = new HashMap();
        List ids = this.collect(this.metaModel.getIdName());
        StringBuilder query = new StringBuilder().append("parent_id IN (");
        this.appendQuestions(query, ids.size());
        query.append(") AND parent_type = '").append(association.getTypeLabel()).append('\'');
        for (Model child : new LazyList<T>(query.toString(), childMetaModel, ids.toArray()).orderBy(childMetaModel.getIdName())) {
            if (childrenByParentId.get(child.get("parent_id")) == null) {
                childrenByParentId.put(child.get("parent_id"), new SuperLazyList());
            }
            ((List)childrenByParentId.get(child.get("parent_id"))).add(child);
        }
        for (Model parent : this.delegate) {
            List children = (List)childrenByParentId.get(parent.getId());
            if (children != null) {
                parent.setChildren(childMetaModel.getModelClass(), children);
                continue;
            }
            parent.setChildren(childMetaModel.getModelClass(), new SuperLazyList<Model>());
        }
    }

    private void processChildren(OneToManyAssociation association) {
        if (this.delegate.isEmpty()) {
            return;
        }
        MetaModel childMetaModel = ModelDelegate.metaModelOf(association.getTargetClass());
        String fkName = association.getFkName();
        HashMap childrenByParentId = new HashMap();
        List ids = this.collect(this.metaModel.getIdName());
        StringBuilder query = new StringBuilder().append(fkName).append(" IN (");
        this.appendQuestions(query, ids.size());
        query.append(')');
        for (Model child : new LazyList<T>(query.toString(), childMetaModel, ids.toArray()).orderBy(childMetaModel.getIdName())) {
            if (childrenByParentId.get(child.get(fkName)) == null) {
                childrenByParentId.put(child.get(fkName), new SuperLazyList());
            }
            ((List)childrenByParentId.get(child.get(fkName))).add(child);
        }
        for (Model parent : this.delegate) {
            List children = (List)childrenByParentId.get(parent.getId());
            if (children != null) {
                parent.setChildren(childMetaModel.getModelClass(), children);
                continue;
            }
            parent.setChildren(childMetaModel.getModelClass(), new SuperLazyList<Model>());
        }
    }

    private void processManyToMany(Many2ManyAssociation association) {
        if (this.delegate.isEmpty()) {
            return;
        }
        MetaModel childMetaModel = ModelDelegate.metaModelOf(association.getTargetClass());
        HashMap childrenByParentId = new HashMap();
        List ids = this.collect(this.metaModel.getIdName());
        List<Map> childResults = new DB(childMetaModel.getDbName()).findAll(childMetaModel.getDialect().selectManyToManyAssociation(association, "the_parent_record_id", ids.size()), ids.toArray());
        for (Map res : childResults) {
            Object child = ModelDelegate.instance(res, childMetaModel);
            Object parentId = res.get("the_parent_record_id");
            if (childrenByParentId.get(parentId) == null) {
                childrenByParentId.put(parentId, new SuperLazyList());
            }
            ((List)childrenByParentId.get(parentId)).add(child);
        }
        for (Model parent : this.delegate) {
            List children = (List)childrenByParentId.get(parent.getId());
            if (children != null) {
                parent.setChildren(childMetaModel.getModelClass(), children);
                continue;
            }
            parent.setChildren(childMetaModel.getModelClass(), new SuperLazyList<Model>());
        }
    }

    public void dump() {
        this.dump(System.out);
    }

    public void dump(OutputStream out) {
        this.hydrate();
        PrintWriter p = new PrintWriter(out);
        for (Model m : this.delegate) {
            p.write(m.toString());
            p.write(10);
        }
        p.flush();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.delegate);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.delegate = (List)in.readObject();
    }
}

