/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.javalite.activejdbc.CaseInsensitiveMap;
import org.javalite.activejdbc.ColumnMetadata;
import org.javalite.activejdbc.MetaModel;
import org.javalite.activejdbc.Model;
import org.javalite.activejdbc.associations.Many2ManyAssociation;
import org.javalite.activejdbc.logging.LogFilter;
import org.javalite.activejdbc.logging.LogLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MetaModels {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaModels.class);
    private final Map<String, MetaModel> metaModelsByTableName = new CaseInsensitiveMap<MetaModel>();
    private final Map<String, MetaModel> metaModelsByClassName = new HashMap<String, MetaModel>();
    private final List<Many2ManyAssociation> many2ManyAssociations = new ArrayList<Many2ManyAssociation>();

    MetaModels() {
    }

    void addMetaModel(MetaModel mm, Class<? extends Model> modelClass) {
        MetaModel o = this.metaModelsByClassName.put(modelClass.getName(), mm);
        if (o != null) {
            LogFilter.log(LOGGER, LogLevel.WARNING, "Double-register: {}: {}", modelClass, (Object)o);
        }
        o = this.metaModelsByTableName.put(mm.getTableName(), mm);
        this.many2ManyAssociations.addAll(mm.getManyToManyAssociations(Collections.emptyList()));
        if (o != null) {
            LogFilter.log(LOGGER, LogLevel.WARNING, "Double-register: {}: {}", (Object)mm.getTableName(), (Object)o);
        }
    }

    MetaModel getMetaModel(Class<? extends Model> modelClass) {
        return this.metaModelsByClassName.get(modelClass.getName());
    }

    MetaModel getMetaModel(String tableName) {
        return this.metaModelsByTableName.get(tableName);
    }

    String[] getTableNames(String dbName) {
        ArrayList<String> tableNames = new ArrayList<String>();
        for (MetaModel metaModel : this.metaModelsByTableName.values()) {
            if (!metaModel.getDbName().equals(dbName)) continue;
            tableNames.add(metaModel.getTableName());
        }
        return tableNames.toArray(new String[tableNames.size()]);
    }

    Class<? extends Model> getModelClass(String tableName) {
        MetaModel mm = this.metaModelsByTableName.get(tableName);
        return mm == null ? null : mm.getModelClass();
    }

    String getTableName(Class<? extends Model> modelClass) {
        return this.metaModelsByClassName.containsKey(modelClass.getName()) ? this.metaModelsByClassName.get(modelClass.getName()).getTableName() : null;
    }

    public void setColumnMetadata(String table, Map<String, ColumnMetadata> metaParams) {
        this.metaModelsByTableName.get(table).setColumnMetadata(metaParams);
    }

    protected List<String> getEdges(String join) {
        ArrayList<String> results = new ArrayList<String>();
        for (Many2ManyAssociation a : this.many2ManyAssociations) {
            if (!a.getJoin().equalsIgnoreCase(join)) continue;
            results.add(this.getMetaModel(a.getSourceClass()).getTableName());
            results.add(this.getMetaModel(a.getTargetClass()).getTableName());
        }
        return results;
    }
}

