/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.cache;

import java.util.Arrays;
import org.javalite.activejdbc.MetaModel;
import org.javalite.activejdbc.ModelDelegate;
import org.javalite.activejdbc.Registry;
import org.javalite.activejdbc.cache.CacheEvent;
import org.javalite.activejdbc.cache.CacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum QueryCache {
    INSTANCE;

    private static final Logger LOGGER;
    private final boolean enabled = Registry.instance().getConfiguration().cacheEnabled();
    private final CacheManager cacheManager = Registry.instance().getConfiguration().getCacheManager();

    public static QueryCache instance() {
        return INSTANCE;
    }

    public void addItem(String tableName, String query, Object[] params, Object cache) {
        if (this.enabled) {
            this.cacheManager.addCache(tableName, this.getKey(tableName, query, params), cache);
        }
    }

    public Object getItem(String tableName, String query, Object[] params) {
        if (this.enabled) {
            String key = this.getKey(tableName, query, params);
            return this.cacheManager.getCache(tableName, key);
        }
        return null;
    }

    private String getKey(String tableName, String query, Object[] params) {
        return tableName + query + (params == null ? null : Arrays.asList(params).toString());
    }

    public void purgeTableCache(MetaModel metaModel) {
        if (this.enabled && metaModel.cached()) {
            this.cacheManager.flush(new CacheEvent(metaModel.getTableName(), ((Object)((Object)this)).getClass().getName()));
        }
    }

    public void purgeTableCache(String tableName) {
        MetaModel mm = ModelDelegate.metaModelFor(tableName);
        if (mm != null && this.enabled && mm.cached()) {
            this.cacheManager.flush(new CacheEvent(mm.getTableName(), ((Object)((Object)this)).getClass().getName()));
        }
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    static {
        LOGGER = LoggerFactory.getLogger(QueryCache.class);
    }
}

