/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.reflection;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.javers.common.reflection.JaversMethod;
import org.javers.common.reflection.TypeResolvingContext;

class JaversMethodFactory {
    private final Class methodSource;

    public JaversMethodFactory(Class methodSource) {
        this.methodSource = methodSource;
    }

    public List<JaversMethod> getAllMethods() {
        ArrayList<JaversMethod> methods = new ArrayList<JaversMethod>();
        HashSet<Integer> added = new HashSet<Integer>();
        TypeResolvingContext context = new TypeResolvingContext();
        for (Class clazz = this.methodSource; clazz != null; clazz = clazz.getSuperclass()) {
            context.addTypeSubstitutions(clazz);
            for (Method m : clazz.getDeclaredMethods()) {
                int methodKey = JaversMethodFactory.methodKey(m);
                if (added.contains(methodKey)) continue;
                methods.add(this.createJMethod(m, context));
                added.add(methodKey);
            }
        }
        return methods;
    }

    private JaversMethod createJMethod(Method rawMethod, TypeResolvingContext context) {
        Type actualReturnType = context.getSubstitution(rawMethod.getGenericReturnType());
        return new JaversMethod(rawMethod, actualReturnType);
    }

    public static int methodKey(Method m) {
        int key = JaversMethodFactory.shaDigest(m.getName());
        for (Class<?> c : m.getParameterTypes()) {
            key += c.hashCode();
        }
        return key;
    }

    private static int shaDigest(String text) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(text.getBytes("UTF-8"));
            byte[] hashBytes = digest.digest();
            int result = 0;
            for (int i = 0; i < hashBytes.length; ++i) {
                result += Math.abs(hashBytes[i]) * (i + 1);
            }
            return result;
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

