/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.snapshot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.javers.common.collections.Optional;
import org.javers.common.collections.Sets;
import org.javers.common.validation.Validate;
import org.javers.core.diff.Change;
import org.javers.core.diff.Diff;
import org.javers.core.diff.DiffFactory;
import org.javers.core.diff.changetype.NewObject;
import org.javers.core.diff.changetype.ObjectRemoved;
import org.javers.core.graph.ObjectNode;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.CdoSnapshotBuilder;
import org.javers.core.snapshot.ShadowGraph;

public class SnapshotDiffer {
    private final DiffFactory diffFactory;

    public SnapshotDiffer(DiffFactory diffFactory) {
        this.diffFactory = diffFactory;
    }

    public List<Change> calculateDiffs(List<CdoSnapshot> snapshots, boolean generateNewObjectChanges) {
        Validate.argumentsAreNotNull(snapshots);
        if (snapshots.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Change> result = new ArrayList<Change>();
        this.addObjectRemovedIfTerminal(result, snapshots.get(0));
        if (snapshots.size() > 1) {
            for (int i = 0; i < snapshots.size() - 1; ++i) {
                CdoSnapshot prev = snapshots.get(i + 1);
                CdoSnapshot current = snapshots.get(i);
                if (current.isTerminal()) continue;
                result.addAll(this.compare(prev, current));
            }
        }
        if (generateNewObjectChanges) {
            this.addInitialChangesIfInitial(result, snapshots.get(snapshots.size() - 1));
        }
        return result;
    }

    public List<Change> calculateMultiDiffs(List<CdoSnapshot> snapshots, boolean generateNewObjectChanges) {
        Validate.argumentsAreNotNull(snapshots);
        HashMap snapshotsStreams = new HashMap();
        for (CdoSnapshot s : snapshots) {
            if (snapshotsStreams.containsKey(s.getGlobalId())) {
                ((List)snapshotsStreams.get(s.getGlobalId())).add(s);
                continue;
            }
            ArrayList<CdoSnapshot> stream = new ArrayList<CdoSnapshot>();
            stream.add(s);
            snapshotsStreams.put(s.getGlobalId(), stream);
        }
        ArrayList<Change> result = new ArrayList<Change>();
        for (List singleMalt : snapshotsStreams.values()) {
            result.addAll(this.calculateDiffs(singleMalt, generateNewObjectChanges));
        }
        Collections.sort(result, new Comparator<Change>(){

            @Override
            public int compare(Change o1, Change o2) {
                return o2.getCommitMetadata().get().getId().compareTo(o1.getCommitMetadata().get().getId());
            }
        });
        return result;
    }

    private void addObjectRemovedIfTerminal(List<Change> changes, CdoSnapshot last) {
        if (last.isTerminal()) {
            changes.add(new ObjectRemoved(last.getGlobalId(), Optional.empty(), last.getCommitMetadata()));
        }
    }

    private void addInitialChangesIfInitial(List<Change> changes, CdoSnapshot first) {
        if (first.isInitial()) {
            CdoSnapshot empty = CdoSnapshotBuilder.emptyCopyOf(first);
            Diff diff = this.diffFactory.create(this.fromSnapshot(empty), this.fromSnapshot(first), Optional.of(first.getCommitMetadata()));
            changes.addAll(diff.getChanges());
            changes.add(new NewObject(first.getGlobalId(), Optional.empty(), first.getCommitMetadata()));
        }
    }

    private List<Change> compare(CdoSnapshot oldVer, CdoSnapshot newVer) {
        Diff diff = this.diffFactory.create(this.fromSnapshot(oldVer), this.fromSnapshot(newVer), Optional.of(newVer.getCommitMetadata()));
        return diff.getChanges();
    }

    private ShadowGraph fromSnapshot(CdoSnapshot snapshot) {
        return new ShadowGraph(Sets.asSet(new ObjectNode(snapshot)));
    }
}

