/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.api;

import java.util.Collections;
import java.util.Map;
import org.javers.common.collections.Optional;
import org.javers.core.commit.CommitId;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;

public class QueryParams {
    private final int limit;
    private final int skip;
    private final Optional<LocalDateTime> from;
    private final Optional<LocalDateTime> to;
    private final Optional<CommitId> commitId;
    private final Optional<Long> version;
    private final Optional<String> author;
    private final Optional<Map<String, String>> commitProperties;
    private final boolean aggregate;
    private final boolean newObjectChanges;
    private final Optional<String> changedProperty;

    QueryParams(int limit, int skip, LocalDateTime from, LocalDateTime to, CommitId commitId, Long version, String author, Map<String, String> commitProperties, boolean aggregate, boolean newObjectChanges, String changedProperty) {
        this.limit = limit;
        this.skip = skip;
        this.from = Optional.fromNullable(from);
        this.to = Optional.fromNullable(to);
        this.commitId = Optional.fromNullable(commitId);
        this.version = Optional.fromNullable(version);
        this.author = Optional.fromNullable(author);
        this.commitProperties = Optional.fromNullable(commitProperties);
        this.aggregate = aggregate;
        this.newObjectChanges = newObjectChanges;
        this.changedProperty = Optional.fromNullable(changedProperty);
    }

    public int limit() {
        return this.limit;
    }

    public int skip() {
        return this.skip;
    }

    public boolean hasDates() {
        return this.from.isPresent() || this.to.isPresent();
    }

    public boolean isDateInRange(LocalDateTime date) {
        if (this.from.isPresent() && this.from.get().isAfter((ReadablePartial)date)) {
            return false;
        }
        return !this.to.isPresent() || !this.to.get().isBefore((ReadablePartial)date);
    }

    public Optional<LocalDateTime> from() {
        return this.from;
    }

    public Optional<LocalDateTime> to() {
        return this.to;
    }

    public Optional<CommitId> commitId() {
        return this.commitId;
    }

    public Map<String, String> commitProperties() {
        return this.commitProperties.isPresent() ? this.commitProperties.get() : Collections.emptyMap();
    }

    public Optional<String> changedProperty() {
        return this.changedProperty;
    }

    public Optional<Long> version() {
        return this.version;
    }

    public Optional<String> author() {
        return this.author;
    }

    public boolean isAggregate() {
        return this.aggregate;
    }

    public boolean newObjectChanges() {
        return this.newObjectChanges;
    }

    public String toString() {
        return "QueryParams{limit=" + this.limit + ", skip=" + this.skip + ", from=" + this.from + ", to=" + this.to + ", commitId=" + this.commitId + ", commitProperties=" + this.commitProperties + ", version=" + this.version + "}";
    }
}

