/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.javers.common.collections.Primitives;
import org.javers.common.collections.WellKnownValueTypes;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.JaversCoreConfiguration;
import org.javers.core.diff.ListCompareAlgorithm;
import org.javers.core.metamodel.clazz.ClientsClassDefinition;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.scanner.ClassScanner;
import org.javers.core.metamodel.type.ArrayType;
import org.javers.core.metamodel.type.ClassType;
import org.javers.core.metamodel.type.CollectionType;
import org.javers.core.metamodel.type.ContainerType;
import org.javers.core.metamodel.type.DehydratedTypeFactory;
import org.javers.core.metamodel.type.DuckType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.KeyValueType;
import org.javers.core.metamodel.type.ListAsSetType;
import org.javers.core.metamodel.type.ListType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.MapContentType;
import org.javers.core.metamodel.type.MapType;
import org.javers.core.metamodel.type.OptionalType;
import org.javers.core.metamodel.type.PrimitiveType;
import org.javers.core.metamodel.type.SetType;
import org.javers.core.metamodel.type.ShallowReferenceType;
import org.javers.core.metamodel.type.TypeFactory;
import org.javers.core.metamodel.type.TypeMapperState;
import org.javers.core.metamodel.type.ValueObjectType;
import org.javers.core.metamodel.type.ValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeMapper {
    private static final Logger logger = LoggerFactory.getLogger(TypeMapper.class);
    private final TypeMapperState state;
    private final DehydratedTypeFactory dehydratedTypeFactory = new DehydratedTypeFactory(this);

    public TypeMapper(ClassScanner classScanner, JaversCoreConfiguration javersCoreConfiguration) {
        TypeFactory typeFactory = new TypeFactory(classScanner, this);
        this.state = new TypeMapperState(typeFactory);
        this.registerCoreTypes(javersCoreConfiguration.getListCompareAlgorithm());
    }

    protected TypeMapper(TypeFactory typeFactory) {
        this.state = new TypeMapperState(typeFactory);
        this.registerCoreTypes(ListCompareAlgorithm.SIMPLE);
    }

    private void registerCoreTypes(ListCompareAlgorithm listCompareAlgorithm) {
        for (Class<?> primitiveOrBox : Primitives.getPrimitiveAndBoxTypes()) {
            this.registerPrimitiveType(primitiveOrBox);
        }
        this.registerPrimitiveType(Enum.class);
        this.addType(new ArrayType((Type)((Object)Object[].class)));
        for (Class<?> valueType : WellKnownValueTypes.getValueTypes()) {
            this.registerValueType(valueType);
        }
        this.addType(new CollectionType((Type)((Object)Collection.class)));
        this.addType(new SetType((Type)((Object)Set.class)));
        if (listCompareAlgorithm == ListCompareAlgorithm.AS_SET) {
            this.addType(new ListAsSetType((Type)((Object)List.class)));
        } else {
            this.addType(new ListType((Type)((Object)List.class)));
        }
        this.addType(new OptionalType());
        this.addType(new MapType((Type)((Object)Map.class)));
    }

    public MapContentType getMapContentType(KeyValueType mapType) {
        JaversType keyType = this.getJaversType(mapType.getKeyType());
        JaversType valueType = this.getJaversType(mapType.getValueType());
        return new MapContentType(keyType, valueType);
    }

    public MapContentType getMapContentType(ContainerType containerType) {
        JaversType keyType = this.getJaversType((Type)((Object)Integer.class));
        JaversType valueType = this.getJaversType(containerType.getItemType());
        return new MapContentType(keyType, valueType);
    }

    public boolean isContainerOfManagedTypes(JaversType javersType) {
        if (!(javersType instanceof ContainerType)) {
            return false;
        }
        return this.getJaversType(((ContainerType)javersType).getItemType()) instanceof ManagedType;
    }

    public boolean isKeyValueTypeWithManagedTypes(JaversType enumerableType) {
        if (enumerableType instanceof KeyValueType) {
            KeyValueType mapType = (KeyValueType)enumerableType;
            JaversType keyType = this.getJaversType(mapType.getKeyType());
            JaversType valueType = this.getJaversType(mapType.getValueType());
            return keyType instanceof ManagedType || valueType instanceof ManagedType;
        }
        return false;
    }

    public boolean isManagedType(JaversType javersType) {
        return javersType instanceof ManagedType;
    }

    public boolean isEnumerableOfManagedTypes(JaversType javersType) {
        return this.isContainerOfManagedTypes(javersType) || this.isKeyValueTypeWithManagedTypes(javersType);
    }

    public JaversType getJaversType(Type javaType) {
        Validate.argumentIsNotNull(javaType);
        return this.state.getJaversType(javaType);
    }

    public boolean isShallowReferenceType(Type javaType) {
        return this.getJaversType(javaType) instanceof ShallowReferenceType;
    }

    public ClassType getJaversClassType(Type javaType) {
        Validate.argumentIsNotNull(javaType);
        JaversType jType = this.getJaversType(javaType);
        if (jType instanceof ClassType) {
            return (ClassType)jType;
        }
        throw new JaversException(JaversExceptionCode.CLASS_MAPPING_ERROR, javaType, jType.getClass().getSimpleName(), ClassType.class.getSimpleName());
    }

    public ManagedType getJaversManagedType(String typeName) {
        return this.getJaversManagedType(this.state.getClassByTypeName(typeName), ManagedType.class);
    }

    public ManagedType getJaversManagedType(GlobalId globalId) {
        return this.getJaversManagedType(this.state.getClassByTypeName(globalId.getTypeName()), ManagedType.class);
    }

    public <T extends ManagedType> T getJaversManagedType(String typeName, Class<T> expectedType) {
        return this.getJaversManagedType(this.state.getClassByTypeName(typeName), expectedType);
    }

    public <T extends ManagedType> T getJaversManagedType(DuckType duckType, Class<T> expectedType) {
        return this.getJaversManagedType(this.state.getClassByDuckType(duckType), expectedType);
    }

    public ManagedType getJaversManagedType(Class javaType) {
        return this.getJaversManagedType(javaType, ManagedType.class);
    }

    public <T extends ManagedType> T getJaversManagedType(Class javaClass, Class<T> expectedType) {
        JaversType mType = this.getJaversType(javaClass);
        if (expectedType.isAssignableFrom(mType.getClass())) {
            return (T)((ManagedType)mType);
        }
        throw new JaversException(JaversExceptionCode.MANAGED_CLASS_MAPPING_ERROR, javaClass, mType.getClass().getSimpleName(), expectedType.getSimpleName());
    }

    public <T extends ManagedType> Optional<T> getJaversManagedTypeMaybe(String typeName, Class<T> expectedType) {
        return this.getJaversManagedTypeMaybe(new DuckType(typeName), expectedType);
    }

    public <T extends ManagedType> Optional<T> getJaversManagedTypeMaybe(DuckType duckType, Class<T> expectedType) {
        try {
            return Optional.of(this.getJaversManagedType(duckType, expectedType));
        }
        catch (JaversException e) {
            if (JaversExceptionCode.TYPE_NAME_NOT_FOUND == e.getCode()) {
                return Optional.empty();
            }
            if (JaversExceptionCode.MANAGED_CLASS_MAPPING_ERROR == e.getCode()) {
                return Optional.empty();
            }
            throw e;
        }
    }

    public <T extends JaversType> T getPropertyType(Property property) {
        Validate.argumentIsNotNull(property);
        try {
            return (T)this.getJaversType(property.getGenericType());
        }
        catch (JaversException e) {
            logger.error("Can't calculate JaversType for property: {}", (Object)property);
            throw e;
        }
    }

    private void registerPrimitiveType(Class<?> primitiveClass) {
        this.addType(new PrimitiveType(primitiveClass));
    }

    public void registerClientsClass(ClientsClassDefinition def) {
        this.state.register(def);
    }

    public void registerValueType(Class<?> valueCLass) {
        this.addType(new ValueType(valueCLass));
    }

    public boolean isValueObject(Type type) {
        JaversType jType = this.getJaversType(type);
        return jType instanceof ValueObjectType;
    }

    public Type getDehydratedType(Type type) {
        return this.dehydratedTypeFactory.build(type);
    }

    public void addType(JaversType jType) {
        Validate.argumentIsNotNull(jType);
        this.state.putIfAbsent(jType.getBaseJavaType(), jType);
    }

    public void addTypes(Collection<JaversType> jTypes) {
        Validate.argumentIsNotNull(jTypes);
        for (JaversType t : jTypes) {
            this.addType(t);
        }
    }

    boolean contains(Type javaType) {
        return this.state.contains(javaType);
    }
}

