/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jbehave.core.embedder.PerformableTree;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.reporters.EscapeMode;
import org.jbehave.core.reporters.FreemarkerProcessor;
import org.jbehave.core.reporters.StackTraceFormatter;
import org.jbehave.core.reporters.TemplateProcessor;
import org.xml.sax.SAXException;

public class SurefireReporter {
    private static final String SUREFIRE_FTL = "ftl/surefire-xml-report.ftl";
    private static final String SUREFIRE_XSD = "xsd/surefire-test-report.xsd";
    private static final String XML = ".xml";
    private static final String DOT = ".";
    private static final String HYPHEN = "-";
    private static final String SLASH = "/";
    private final Class<?> embeddableClass;
    private final TestCaseNamingStrategy namingStrategy;
    private final boolean includeProperties;
    private final String reportName;
    private final boolean reportByStory;
    private TemplateProcessor processor = new FreemarkerProcessor();

    public SurefireReporter(Class<?> embeddableClass) {
        this(embeddableClass, new Options());
    }

    public SurefireReporter(Class<?> embeddableClass, Options options) {
        this.embeddableClass = embeddableClass;
        this.namingStrategy = options.namingStrategy;
        this.includeProperties = options.includeProperties;
        this.reportName = options.reportName;
        this.reportByStory = options.reportByStory;
    }

    public synchronized void generate(PerformableTree.PerformableRoot root, File outputDirectory) {
        List<PerformableTree.PerformableStory> stories = root.getStories();
        if (this.reportByStory) {
            for (PerformableTree.PerformableStory story : stories) {
                String name = this.reportName(story.getStory().getPath());
                File file = this.outputFile(outputDirectory, name);
                this.generateReport(Arrays.asList(story), file);
            }
        } else {
            File file = this.outputFile(outputDirectory, this.reportName);
            this.generateReport(stories, file);
        }
    }

    private String reportName(String path) {
        return this.reportName + HYPHEN + StringUtils.replaceAll((String)StringUtils.substringBefore((String)path, (String)DOT), (String)SLASH, (String)DOT);
    }

    private void generateReport(List<PerformableTree.PerformableStory> stories, File file) {
        try {
            HashMap<String, Object> dataModel = new HashMap<String, Object>();
            dataModel.put("testsuite", new TestSuite(this.embeddableClass, this.namingStrategy, stories, this.includeProperties));
            this.processor.process(SUREFIRE_FTL, dataModel, new FileWriter(file));
            this.validateOutput(file, SUREFIRE_XSD);
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException("Failed to generate surefire report", e);
        }
    }

    private File outputFile(File outputDirectory, String name) {
        File outputDir = new File(outputDirectory, "view");
        outputDir.mkdirs();
        if (!name.endsWith(XML)) {
            name = name + XML;
        }
        return new File(outputDir, name);
    }

    private void validateOutput(File file, String surefireXsd) throws SAXException, IOException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new StreamSource(this.getClass().getClassLoader().getResourceAsStream(surefireXsd)));
        Validator validator = schema.newValidator();
        validator.validate(new StreamSource(file));
    }

    public static class TestCounts {
        private int tests = 0;
        private int skipped = 0;
        private int errors = 0;
        private int failures = 0;

        public int getTests() {
            return this.tests;
        }

        public int getSkipped() {
            return this.skipped;
        }

        public int getErrors() {
            return this.errors;
        }

        public int getFailures() {
            return this.failures;
        }

        public void addFailure() {
            ++this.failures;
            ++this.tests;
        }

        public void addSkipped() {
            ++this.skipped;
            ++this.tests;
        }

        public void addSuccessful() {
            ++this.tests;
        }
    }

    public static class TestFailure {
        private final Throwable failure;

        public TestFailure(Throwable failure) {
            this.failure = failure;
        }

        public boolean hasFailure() {
            return this.failure != null;
        }

        public String getMessage() {
            if (this.hasFailure()) {
                return EscapeMode.XML.escapeString(this.failure.getMessage());
            }
            return "";
        }

        public String getType() {
            if (this.hasFailure()) {
                return this.failure.getClass().getName();
            }
            return "";
        }

        public String getStackTrace() {
            if (this.hasFailure()) {
                String stackTrace = new StackTraceFormatter(true).stackTrace(this.failure);
                return EscapeMode.XML.escapeString(stackTrace);
            }
            return "";
        }
    }

    public static class BreadcrumbNamingStrategy
    implements TestCaseNamingStrategy {
        private static final String DEFAULT_BREADCRUMB = " > ";
        private final String breadcrumb;

        public BreadcrumbNamingStrategy() {
            this(DEFAULT_BREADCRUMB);
        }

        public BreadcrumbNamingStrategy(String breadcrumb) {
            this.breadcrumb = breadcrumb;
        }

        @Override
        public String resolveName(Story story, Scenario scenario) {
            String path = story.getPath();
            File file = new File(path);
            ArrayList<String> parentNames = new ArrayList<String>();
            this.collectParentNames(file, parentNames);
            String parentPath = StringUtils.join(parentNames, (String)this.breadcrumb);
            String name = StringUtils.substringBefore((String)file.getName(), (String)SurefireReporter.DOT);
            return parentPath + this.breadcrumb + name + SurefireReporter.DOT + scenario.getTitle();
        }

        private void collectParentNames(File file, List<String> parents) {
            if (file.getParent() != null) {
                String name = file.getParentFile().getName();
                if (!StringUtils.isBlank((CharSequence)name)) {
                    parents.add(0, name);
                }
                this.collectParentNames(file.getParentFile(), parents);
            }
        }
    }

    public static class SimpleNamingStrategy
    implements TestCaseNamingStrategy {
        @Override
        public String resolveName(Story story, Scenario scenario) {
            String path = story.getPath();
            File file = new File(path);
            String name = StringUtils.substringBefore((String)file.getName(), (String)SurefireReporter.DOT);
            return name + SurefireReporter.DOT + scenario.getTitle();
        }
    }

    public static interface TestCaseNamingStrategy {
        public String resolveName(Story var1, Scenario var2);
    }

    public static class TestCase {
        private final Class<?> embeddableClass;
        private final String name;
        private long time;
        private TestFailure failure;

        public TestCase(Class<?> embeddableClass, String name, long time) {
            this.embeddableClass = embeddableClass;
            this.name = name;
            this.time = time;
        }

        public String getName() {
            return this.name;
        }

        public String getClassname() {
            return this.embeddableClass.getName();
        }

        public long getTime() {
            return this.time;
        }

        public boolean hasFailure() {
            return this.failure != null;
        }

        public TestFailure getFailure() {
            return this.failure;
        }

        public void setFailure(TestFailure failure) {
            this.failure = failure;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SIMPLE_STYLE);
        }
    }

    public static class TestSuite {
        private final Class<?> embeddableClass;
        private final TestCaseNamingStrategy namingStrategy;
        private final TestCounts testCounts;
        private final List<TestCase> testCases;
        private final boolean includeProperties;

        public TestSuite(Class<?> embeddableClass, TestCaseNamingStrategy namingStrategy, List<PerformableTree.PerformableStory> stories, boolean includeProperties) {
            this.embeddableClass = embeddableClass;
            this.namingStrategy = namingStrategy;
            this.testCounts = this.collectTestCounts(stories);
            this.testCases = this.collectTestCases(stories);
            this.includeProperties = includeProperties;
        }

        private TestCounts collectTestCounts(List<PerformableTree.PerformableStory> stories) {
            TestCounts counts = new TestCounts();
            for (PerformableTree.PerformableStory story : stories) {
                for (PerformableTree.PerformableScenario scenario : story.getScenarios()) {
                    PerformableTree.Status status = scenario.getStatus();
                    if (status == null) {
                        counts.addSkipped();
                        continue;
                    }
                    switch (status) {
                        case FAILED: {
                            counts.addFailure();
                            break;
                        }
                        case PENDING: 
                        case NOT_ALLOWED: 
                        case NOT_PERFORMED: {
                            counts.addSkipped();
                            break;
                        }
                        case SUCCESSFUL: {
                            counts.addSuccessful();
                        }
                    }
                }
            }
            return counts;
        }

        private long totalTime(List<TestCase> testCases) {
            long total = 0L;
            for (TestCase tc : testCases) {
                total += tc.getTime();
            }
            return total;
        }

        private List<TestCase> collectTestCases(List<PerformableTree.PerformableStory> stories) {
            ArrayList<TestCase> testCases = new ArrayList<TestCase>();
            for (PerformableTree.PerformableStory story : stories) {
                for (PerformableTree.PerformableScenario scenario : story.getScenarios()) {
                    String name = this.namingStrategy.resolveName(story.getStory(), scenario.getScenario());
                    long time = scenario.getTiming().getDurationInMillis();
                    TestCase tc = new TestCase(this.embeddableClass, name, time);
                    if (scenario.getStatus() == PerformableTree.Status.FAILED) {
                        tc.setFailure(new TestFailure(scenario.getFailure()));
                    }
                    testCases.add(tc);
                }
            }
            return testCases;
        }

        public String getName() {
            return this.embeddableClass.getName();
        }

        public long getTime() {
            return this.totalTime(this.testCases);
        }

        public int getTests() {
            return this.testCounts.getTests();
        }

        public int getSkipped() {
            return this.testCounts.getSkipped();
        }

        public int getErrors() {
            return this.testCounts.getErrors();
        }

        public int getFailures() {
            return this.testCounts.getFailures();
        }

        public Properties getProperties() {
            return this.includeProperties ? System.getProperties() : new Properties();
        }

        public List<TestCase> getTestCases() {
            return this.testCases;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SIMPLE_STYLE);
        }
    }

    public static class Options {
        public static final String DEFAULT_REPORT_NAME = "jbehave-surefire";
        public static final TestCaseNamingStrategy DEFAULT_NAMING_STRATEGY = new SimpleNamingStrategy();
        public static final boolean DEFAULT_INCLUDE_PROPERTIES = true;
        public static final boolean DEFAULT_REPORT_BY_STORY = false;
        private String reportName;
        private TestCaseNamingStrategy namingStrategy;
        private boolean includeProperties;
        private boolean reportByStory;

        public Options() {
            this(DEFAULT_REPORT_NAME, DEFAULT_NAMING_STRATEGY, false, true);
        }

        public Options(String reportName, TestCaseNamingStrategy namingStrategy, boolean reportByStory, boolean includeProperties) {
            this.reportName = reportName;
            this.namingStrategy = namingStrategy;
            this.includeProperties = includeProperties;
            this.reportByStory = reportByStory;
        }

        public Options useReportName(String reportName) {
            this.reportName = reportName;
            return this;
        }

        public Options withNamingStrategy(TestCaseNamingStrategy strategy) {
            this.namingStrategy = strategy;
            return this;
        }

        public Options doReportByStory(boolean reportByStory) {
            this.reportByStory = reportByStory;
            return this;
        }

        public Options doIncludeProperties(boolean includeProperties) {
            this.includeProperties = includeProperties;
            return this;
        }
    }
}

