/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.model.ExamplesTable;

public class TableParsers {
    private static final String ROW_SEPARATOR_PATTERN = "\r?\n";

    public ExamplesTable.TablePropertiesQueue parseProperties(String tableAsString, Keywords keywords) {
        return this.parseProperties(tableAsString, keywords.examplesTableHeaderSeparator(), keywords.examplesTableValueSeparator(), keywords.examplesTableIgnorableSeparator());
    }

    public ExamplesTable.TablePropertiesQueue parseProperties(String tableAsString, String headerSeparator, String valueSeparator, String ignorableSeparator) {
        LinkedList<ExamplesTable.TableProperties> properties = new LinkedList<ExamplesTable.TableProperties>();
        String tableWithoutProperties = tableAsString.trim();
        Matcher matcher = ExamplesTable.INLINED_PROPERTIES_PATTERN.matcher(tableWithoutProperties);
        while (matcher.matches()) {
            String propertiesAsString = matcher.group(1);
            propertiesAsString = StringUtils.replace((String)propertiesAsString, (String)"\\{", (String)"{");
            propertiesAsString = StringUtils.replace((String)propertiesAsString, (String)"\\}", (String)"}");
            properties.add(new ExamplesTable.TableProperties(propertiesAsString, headerSeparator, valueSeparator, ignorableSeparator));
            tableWithoutProperties = matcher.group(2).trim();
            matcher = ExamplesTable.INLINED_PROPERTIES_PATTERN.matcher(tableWithoutProperties);
        }
        if (properties.isEmpty()) {
            properties.add(new ExamplesTable.TableProperties("", headerSeparator, valueSeparator, ignorableSeparator));
        }
        return new ExamplesTable.TablePropertiesQueue(tableWithoutProperties, properties);
    }

    public ExamplesTable.TableRows parseRows(String tableAsString, ExamplesTable.TableProperties properties) {
        String[] rows;
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
        for (String row : rows = tableAsString.split(ROW_SEPARATOR_PATTERN)) {
            if (row.startsWith(properties.getIgnorableSeparator()) || row.isEmpty()) continue;
            if (headers.isEmpty()) {
                headers.addAll(this.parseRow(row, true, properties));
                continue;
            }
            List<String> columns = this.parseRow(row, false, properties);
            LinkedHashMap map = new LinkedHashMap();
            for (int column = 0; column < columns.size(); ++column) {
                if (column >= headers.size()) continue;
                map.put(headers.get(column), columns.get(column));
            }
            data.add(map);
        }
        return new ExamplesTable.TableRows(headers, data);
    }

    public List<String> parseRow(String rowAsString, boolean header, ExamplesTable.TableProperties properties) {
        String separator = header ? properties.getHeaderSeparator() : properties.getValueSeparator();
        return this.parseRow(rowAsString, separator, properties.getCommentSeparator(), properties.isTrim());
    }

    private List<String> parseRow(String rowAsString, String separator, String commentSeparator, boolean trimValues) {
        int lastIndex;
        StringBuilder regex = new StringBuilder();
        for (char c : separator.toCharArray()) {
            regex.append("\\").append(c);
        }
        ArrayList<String> values = new ArrayList<String>();
        for (String value : rowAsString.split(regex.toString(), -1)) {
            String stripped = StringUtils.substringBefore((String)value, (String)commentSeparator);
            String trimmed = trimValues ? stripped.trim() : stripped;
            values.add(StringUtils.substringBefore((String)trimmed, (String)commentSeparator));
        }
        if (StringUtils.isBlank((CharSequence)((CharSequence)values.get(0)))) {
            values.remove(0);
        }
        if ((lastIndex = values.size() - 1) != -1 && StringUtils.isBlank((CharSequence)((CharSequence)values.get(lastIndex)))) {
            values.remove(lastIndex);
        }
        return values;
    }
}

