/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.embedder;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class StoryControls {
    private boolean dryRun = false;
    private boolean resetStateBeforeStory = true;
    private boolean resetStateBeforeScenario = true;
    private boolean skipScenariosAfterFailure = false;
    private boolean skipBeforeAndAfterScenarioStepsIfGivenStory = false;
    private boolean ignoreMetaFiltersIfGivenStory = false;
    private boolean metaByRow = false;
    private String storyMetaPrefix = "";
    private String scenarioMetaPrefix = "";
    private boolean skipStoryIfGivenStoryFailed = false;
    private NumberFormat storyIndexFormat;
    private final ThreadLocal<StoryControls> currentStoryControls = ThreadLocal.withInitial(() -> new StoryControls(this));

    public StoryControls(StoryControls storyControls) {
        this.dryRun = storyControls.dryRun;
        this.resetStateBeforeStory = storyControls.resetStateBeforeStory;
        this.resetStateBeforeScenario = storyControls.resetStateBeforeScenario;
        this.skipScenariosAfterFailure = storyControls.skipScenariosAfterFailure;
        this.skipBeforeAndAfterScenarioStepsIfGivenStory = storyControls.skipBeforeAndAfterScenarioStepsIfGivenStory;
        this.ignoreMetaFiltersIfGivenStory = storyControls.ignoreMetaFiltersIfGivenStory;
        this.metaByRow = storyControls.metaByRow;
        this.storyMetaPrefix = storyControls.storyMetaPrefix;
        this.scenarioMetaPrefix = storyControls.scenarioMetaPrefix;
        this.skipStoryIfGivenStoryFailed = storyControls.skipStoryIfGivenStoryFailed;
        this.storyIndexFormat = storyControls.storyIndexFormat;
        this.currentStoryControls.set(null);
    }

    public StoryControls() {
    }

    public StoryControls currentStoryControls() {
        return this.currentStoryControls.get();
    }

    public boolean dryRun() {
        return this.currentStoryControls().dryRun;
    }

    public boolean resetStateBeforeStory() {
        return this.currentStoryControls().resetStateBeforeStory;
    }

    public boolean resetStateBeforeScenario() {
        return this.currentStoryControls().resetStateBeforeScenario;
    }

    public void resetCurrentStoryControls() {
        this.currentStoryControls.remove();
    }

    public boolean skipScenariosAfterFailure() {
        return this.currentStoryControls().skipScenariosAfterFailure;
    }

    public boolean skipBeforeAndAfterScenarioStepsIfGivenStory() {
        return this.currentStoryControls().skipBeforeAndAfterScenarioStepsIfGivenStory;
    }

    public boolean ignoreMetaFiltersIfGivenStory() {
        return this.currentStoryControls().ignoreMetaFiltersIfGivenStory;
    }

    public boolean metaByRow() {
        return this.currentStoryControls().metaByRow;
    }

    public String storyMetaPrefix() {
        return this.currentStoryControls().storyMetaPrefix;
    }

    public String scenarioMetaPrefix() {
        return this.currentStoryControls().scenarioMetaPrefix;
    }

    public boolean skipStoryIfGivenStoryFailed() {
        return this.currentStoryControls().skipStoryIfGivenStoryFailed;
    }

    public NumberFormat storyIndexFormat() {
        return Optional.ofNullable(this.currentStoryControls().storyIndexFormat).orElseGet(() -> new DecimalFormat(" [0]"));
    }

    public StoryControls doDryRun(boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public StoryControls doResetStateBeforeScenario(boolean resetStateBeforeScenario) {
        this.resetStateBeforeScenario = resetStateBeforeScenario;
        return this;
    }

    public StoryControls doResetStateBeforeStory(boolean resetStateBeforeStory) {
        this.resetStateBeforeStory = resetStateBeforeStory;
        return this;
    }

    public StoryControls doSkipScenariosAfterFailure(boolean skipScenariosAfterFailure) {
        this.skipScenariosAfterFailure = skipScenariosAfterFailure;
        return this;
    }

    public StoryControls doSkipBeforeAndAfterScenarioStepsIfGivenStory(boolean skipBeforeAndAfterScenarioStepsIfGivenStory) {
        this.skipBeforeAndAfterScenarioStepsIfGivenStory = skipBeforeAndAfterScenarioStepsIfGivenStory;
        return this;
    }

    public StoryControls doIgnoreMetaFiltersIfGivenStory(boolean ignoreMetaFiltersIfGivenStory) {
        this.ignoreMetaFiltersIfGivenStory = ignoreMetaFiltersIfGivenStory;
        return this;
    }

    public StoryControls doMetaByRow(boolean metaByRow) {
        this.metaByRow = metaByRow;
        return this;
    }

    public StoryControls useStoryMetaPrefix(String storyMetaPrefix) {
        this.storyMetaPrefix = storyMetaPrefix;
        return this;
    }

    public StoryControls useScenarioMetaPrefix(String scenarioMetaPrefix) {
        this.scenarioMetaPrefix = scenarioMetaPrefix;
        return this;
    }

    public StoryControls doSkipStoryIfGivenStoryFailed(boolean skipStoryIfGivenStoryFailed) {
        this.skipStoryIfGivenStoryFailed = skipStoryIfGivenStoryFailed;
        return this;
    }

    public StoryControls useStoryIndexFormat(NumberFormat storyIndexFormat) {
        this.storyIndexFormat = storyIndexFormat;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

