/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.io;

import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.jbehave.core.io.CodeLocations;
import org.jbehave.core.io.InvalidStoryResource;
import org.jbehave.core.io.ResourceLoader;
import org.jbehave.core.io.StoryLoader;
import org.jbehave.core.io.StoryResourceNotFound;

public class LoadFromRelativeFile
implements ResourceLoader,
StoryLoader {
    private final Charset charset;
    private final StoryFilePath[] traversals;
    private final URL location;

    public LoadFromRelativeFile(URL location) {
        this(location, StandardCharsets.UTF_8);
    }

    public LoadFromRelativeFile(URL location, Charset charset) {
        this(location, charset, LoadFromRelativeFile.mavenModuleStoryFilePath("src/test/java"));
    }

    public LoadFromRelativeFile(URL location, StoryFilePath ... traversals) {
        this(location, StandardCharsets.UTF_8, traversals);
    }

    public LoadFromRelativeFile(URL location, Charset charset, StoryFilePath ... traversals) {
        this.charset = charset;
        this.traversals = traversals;
        this.location = location;
    }

    @Override
    public String loadResourceAsText(String resourcePath) {
        ArrayList<String> traversalPaths = new ArrayList<String>();
        String locationPath = LoadFromRelativeFile.normalise(new File(CodeLocations.getPathFromURL(this.location)).getAbsolutePath());
        for (StoryFilePath traversal : this.traversals) {
            String filePath = locationPath.replace(traversal.toRemove, traversal.relativePath) + "/" + resourcePath;
            File file = new File(filePath);
            if (file.exists()) {
                return this.loadContent(filePath);
            }
            traversalPaths.add(filePath);
        }
        throw new StoryResourceNotFound(resourcePath, traversalPaths);
    }

    @Override
    public String loadStoryAsText(String storyPath) {
        ArrayList<String> traversalPaths = new ArrayList<String>();
        String locationPath = new File(CodeLocations.getPathFromURL(this.location)).getAbsolutePath();
        for (StoryFilePath traversal : this.traversals) {
            String filePath = locationPath.replace(traversal.toRemove, traversal.relativePath) + "/" + storyPath;
            File file = new File(filePath);
            if (file.exists()) {
                return this.loadContent(filePath);
            }
            traversalPaths.add(filePath);
        }
        throw new StoryResourceNotFound(storyPath, traversalPaths);
    }

    protected String loadContent(String path) {
        try {
            return FileUtils.readFileToString((File)new File(path), (Charset)this.charset);
        }
        catch (Exception e) {
            throw new InvalidStoryResource(path, e);
        }
    }

    private static String normalise(String path) {
        return path.replace('\\', '/');
    }

    public static StoryFilePath mavenModuleStoryFilePath(String relativePath) {
        return new StoryFilePath("target/classes", relativePath);
    }

    public static StoryFilePath mavenModuleTestStoryFilePath(String relativePath) {
        return new StoryFilePath("target/test-classes", relativePath);
    }

    public static StoryFilePath intellijProjectStoryFilePath(String relativePath) {
        return new StoryFilePath("classes/production", relativePath);
    }

    public static StoryFilePath intellijProjectTestStoryFilePath(String relativePath) {
        return new StoryFilePath("classes/test", relativePath);
    }

    public static class StoryFilePath {
        private final String toRemove;
        private final String relativePath;

        public StoryFilePath(String toRemove, String relativePath) {
            this.toRemove = LoadFromRelativeFile.normalise(toRemove);
            this.relativePath = LoadFromRelativeFile.normalise(relativePath);
        }
    }
}

