/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.jbehave.core.io.StoryNameResolver;
import org.jbehave.core.io.UnderscoredToCapitalized;
import org.jbehave.core.reporters.FreemarkerProcessor;
import org.jbehave.core.reporters.TemplateableViewGenerator;

public class FreemarkerViewGenerator
extends TemplateableViewGenerator {
    public FreemarkerViewGenerator() {
        this(FreemarkerViewGenerator.class);
    }

    public FreemarkerViewGenerator(Class<?> templateLoadingFrom) {
        this((StoryNameResolver)new UnderscoredToCapitalized(), templateLoadingFrom.getClassLoader());
    }

    public FreemarkerViewGenerator(ClassLoader templateLoadingFrom) {
        this((StoryNameResolver)new UnderscoredToCapitalized(), templateLoadingFrom);
    }

    public FreemarkerViewGenerator(StoryNameResolver nameResolver, Class<?> templateLoadingFrom) {
        this(nameResolver, templateLoadingFrom.getClassLoader());
    }

    public FreemarkerViewGenerator(StoryNameResolver nameResolver, ClassLoader templateLoadingFrom) {
        this(nameResolver, templateLoadingFrom, StandardCharsets.ISO_8859_1);
    }

    public FreemarkerViewGenerator(StoryNameResolver nameResolver, Class<?> templateLoadingFrom, Charset charset) {
        this(nameResolver, templateLoadingFrom.getClassLoader(), charset);
    }

    public FreemarkerViewGenerator(StoryNameResolver nameResolver, ClassLoader templateLoadingFrom, Charset charset) {
        super(nameResolver, new FreemarkerProcessor(templateLoadingFrom), charset);
    }

    @Override
    public Properties defaultViewProperties() {
        Properties properties = new Properties(super.defaultViewProperties());
        properties.setProperty("views", "ftl/jbehave-views.ftl");
        properties.setProperty("maps", "ftl/jbehave-maps.ftl");
        properties.setProperty("reports", "ftl/jbehave-reports.ftl");
        properties.setProperty("decorated", "ftl/jbehave-report-decorated.ftl");
        properties.setProperty("nonDecorated", "ftl/jbehave-report-non-decorated.ftl");
        return properties;
    }
}

