/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.lang.reflect.Method;
import java.util.List;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.parsers.StepMatcher;
import org.jbehave.core.parsers.StepPatternParser;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.PatternVariantBuilder;
import org.jbehave.core.steps.StepCandidate;
import org.jbehave.core.steps.StepCreator;
import org.jbehave.core.steps.StepType;

public abstract class AbstractCandidateSteps
implements CandidateSteps {
    private final Configuration configuration;

    protected AbstractCandidateSteps(Configuration configuration) {
        this.configuration = configuration;
    }

    protected Configuration configuration() {
        return this.configuration;
    }

    protected void addCandidatesFromVariants(List<StepCandidate> candidates, Method method, StepType stepType, String value, int priority, Class<?> type, InjectableStepsFactory stepsFactory, String[] steps) {
        StepPatternParser stepPatternParser = this.configuration.stepPatternParser();
        PatternVariantBuilder patternVariantBuilder = new PatternVariantBuilder(value);
        for (String variant : patternVariantBuilder.allVariants()) {
            StepMatcher stepMatcher = stepPatternParser.parseStep(stepType, variant);
            StepCreator stepCreator = this.createStepCreator(type, stepsFactory, stepMatcher);
            stepCreator.useParanamer(this.configuration.paranamer());
            StepCandidate candidate = new StepCandidate(variant, priority, stepType, method, type, stepsFactory, this.configuration.keywords(), stepMatcher, stepPatternParser.getPrefix(), stepCreator, steps, this.configuration.stepMonitor());
            candidates.add(candidate);
        }
    }

    protected final StepCreator createStepCreator(Class<?> type, InjectableStepsFactory stepsFactory) {
        return this.createStepCreator(type, stepsFactory, null);
    }

    private StepCreator createStepCreator(Class<?> type, InjectableStepsFactory stepsFactory, StepMatcher stepMatcher) {
        return new StepCreator(type, stepsFactory, this.configuration.stepsContext(), this.configuration.parameterConverters(), this.configuration.expressionResolver(), this.configuration.parameterControls(), stepMatcher, this.configuration.stepMonitor(), this.configuration.storyControls().dryRun());
    }
}

