/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.annotations.AfterStories;
import org.jbehave.core.annotations.AfterStory;
import org.jbehave.core.annotations.Aliases;
import org.jbehave.core.annotations.BeforeScenario;
import org.jbehave.core.annotations.BeforeStories;
import org.jbehave.core.annotations.BeforeStory;
import org.jbehave.core.annotations.Composite;
import org.jbehave.core.annotations.Given;
import org.jbehave.core.annotations.ScenarioType;
import org.jbehave.core.annotations.Then;
import org.jbehave.core.annotations.When;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.MostUsefulConfiguration;
import org.jbehave.core.io.StoryLoader;
import org.jbehave.core.model.Alias;
import org.jbehave.core.model.AliasVariant;
import org.jbehave.core.parsers.AliasParser;
import org.jbehave.core.steps.AbstractCandidateSteps;
import org.jbehave.core.steps.BeforeOrAfterStep;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.InstanceStepsFactory;
import org.jbehave.core.steps.StepCandidate;
import org.jbehave.core.steps.StepCreator;
import org.jbehave.core.steps.StepType;

public class Steps
extends AbstractCandidateSteps {
    private final Class<?> type;
    private final InjectableStepsFactory stepsFactory;

    public Steps() {
        this(new MostUsefulConfiguration());
    }

    public Steps(Configuration configuration) {
        super(configuration);
        this.type = this.getClass();
        this.stepsFactory = new InstanceStepsFactory(configuration, this);
    }

    public Steps(Configuration configuration, Object instance) {
        this(configuration, instance.getClass(), new InstanceStepsFactory(configuration, instance));
    }

    public Steps(Configuration configuration, Class<?> type, InjectableStepsFactory stepsFactory) {
        super(configuration);
        this.type = type;
        this.stepsFactory = stepsFactory;
    }

    public Class<?> type() {
        return this.type;
    }

    public Object instance() {
        return this.stepsFactory.createInstanceOfType(this.type);
    }

    @Override
    public List<StepCandidate> listCandidates() {
        Map<StepType, List<Alias>> aliases = this.findAliases();
        ArrayList<StepCandidate> candidates = new ArrayList<StepCandidate>();
        for (Method method : this.allMethods()) {
            int priority;
            String value;
            Annotation annotation;
            if (method.isAnnotationPresent(Given.class)) {
                annotation = method.getAnnotation(Given.class);
                value = annotation.value();
                priority = annotation.priority();
                this.addCandidatesFromVariants(candidates, method, StepType.GIVEN, value, priority);
                this.addCandidatesFromAliases(candidates, method, StepType.GIVEN, priority);
                Steps.findVariants(StepType.GIVEN, value, aliases).forEach(variant -> this.addCandidatesFromVariants(candidates, method, StepType.GIVEN, variant.getValue(), priority));
            }
            if (method.isAnnotationPresent(When.class)) {
                annotation = method.getAnnotation(When.class);
                value = annotation.value();
                priority = annotation.priority();
                this.addCandidatesFromVariants(candidates, method, StepType.WHEN, value, priority);
                this.addCandidatesFromAliases(candidates, method, StepType.WHEN, priority);
                Steps.findVariants(StepType.WHEN, value, aliases).forEach(variant -> this.addCandidatesFromVariants(candidates, method, StepType.WHEN, variant.getValue(), priority));
            }
            if (!method.isAnnotationPresent(Then.class)) continue;
            annotation = method.getAnnotation(Then.class);
            value = annotation.value();
            priority = annotation.priority();
            this.addCandidatesFromVariants(candidates, method, StepType.THEN, value, priority);
            this.addCandidatesFromAliases(candidates, method, StepType.THEN, priority);
            Steps.findVariants(StepType.THEN, value, aliases).forEach(variant -> this.addCandidatesFromVariants(candidates, method, StepType.THEN, variant.getValue(), priority));
        }
        return candidates;
    }

    private static Collection<AliasVariant> findVariants(StepType stepType, String stepValue, Map<StepType, List<Alias>> aliases) {
        return aliases.getOrDefault((Object)stepType, Collections.emptyList()).stream().filter(alias -> stepValue.equals(alias.getStepIdentifier())).map(Alias::getVariants).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Map<StepType, List<Alias>> findAliases() {
        StoryLoader resourceLoader = this.configuration().storyLoader();
        AliasParser aliasParser = this.configuration().aliasParser();
        Collection aliases = this.configuration().aliasPaths().stream().map(resourceLoader::loadResourceAsText).collect(Collectors.collectingAndThen(Collectors.toSet(), aliasParser::parse));
        return aliases.stream().collect(Collectors.groupingBy(Alias::getType, Collectors.toList()));
    }

    private void addCandidatesFromVariants(List<StepCandidate> candidates, Method method, StepType stepType, String value, int priority) {
        String[] composedSteps = method.isAnnotationPresent(Composite.class) ? method.getAnnotation(Composite.class).steps() : new String[]{};
        this.addCandidatesFromVariants(candidates, method, stepType, value, priority, this.type, this.stepsFactory, composedSteps);
    }

    private void addCandidatesFromAliases(List<StepCandidate> candidates, Method method, StepType stepType, int priority) {
        if (method.isAnnotationPresent(Aliases.class)) {
            String[] aliases;
            for (String alias : aliases = method.getAnnotation(Aliases.class).values()) {
                this.addCandidatesFromVariants(candidates, method, stepType, alias, priority);
            }
        }
        if (method.isAnnotationPresent(org.jbehave.core.annotations.Alias.class)) {
            String alias = method.getAnnotation(org.jbehave.core.annotations.Alias.class).value();
            this.addCandidatesFromVariants(candidates, method, stepType, alias, priority);
        }
    }

    @Override
    public List<BeforeOrAfterStep> listBeforeStories() {
        return this.listSteps(BeforeStories.class, a -> true, BeforeStories::order);
    }

    @Override
    public List<BeforeOrAfterStep> listAfterStories() {
        return this.listSteps(AfterStories.class, a -> true, AfterStories::order);
    }

    @Override
    public List<BeforeOrAfterStep> listBeforeStory(boolean givenStory) {
        return this.listSteps(BeforeStory.class, a -> a.uponGivenStory() == givenStory, BeforeStory::order);
    }

    @Override
    public List<BeforeOrAfterStep> listAfterStory(boolean givenStory) {
        return this.listSteps(AfterStory.class, a -> a.uponGivenStory() == givenStory, AfterStory::order);
    }

    @Override
    public Map<ScenarioType, List<BeforeOrAfterStep>> listBeforeScenario() {
        return this.listBeforeOrAfterScenarioSteps(BeforeScenario.class, (a, scenarioType) -> a.uponType() == scenarioType, BeforeScenario::order, a -> AfterScenario.Outcome.ANY);
    }

    @Override
    public Map<ScenarioType, List<BeforeOrAfterStep>> listAfterScenario() {
        return this.listBeforeOrAfterScenarioSteps(AfterScenario.class, (a, scenarioType) -> a.uponType() == scenarioType, AfterScenario::order, AfterScenario::uponOutcome);
    }

    public <T extends Annotation> Map<ScenarioType, List<BeforeOrAfterStep>> listBeforeOrAfterScenarioSteps(Class<T> annotationClass, BiPredicate<T, ScenarioType> predicate, ToIntFunction<T> order, Function<T, AfterScenario.Outcome> outcome) {
        StepCreator stepCreator = this.createStepCreator(this.type, this.stepsFactory);
        Map<Method, T> methods = this.methodsAnnotatedWith(annotationClass);
        EnumMap<ScenarioType, List<BeforeOrAfterStep>> stepsPerType = new EnumMap<ScenarioType, List<BeforeOrAfterStep>>(ScenarioType.class);
        for (ScenarioType scenarioType : ScenarioType.values()) {
            stepsPerType.put(scenarioType, this.listSteps(methods, a -> predicate.test(a, scenarioType), order, outcome, stepCreator));
        }
        return stepsPerType;
    }

    private <T extends Annotation> List<BeforeOrAfterStep> listSteps(Class<T> annotationClass, Predicate<T> predicate, ToIntFunction<T> order) {
        StepCreator stepCreator = this.createStepCreator(this.type, this.stepsFactory);
        return this.listSteps(this.methodsAnnotatedWith(annotationClass), predicate, order, a -> AfterScenario.Outcome.ANY, stepCreator);
    }

    private <T extends Annotation> List<BeforeOrAfterStep> listSteps(Map<Method, T> methods, Predicate<T> predicate, ToIntFunction<T> order, Function<T, AfterScenario.Outcome> outcome, StepCreator stepCreator) {
        return methods.entrySet().stream().filter(e -> predicate.test((Annotation)e.getValue())).map(e -> {
            Method method = (Method)e.getKey();
            Annotation annotation = (Annotation)e.getValue();
            return new BeforeOrAfterStep(method, order.applyAsInt(annotation), (AfterScenario.Outcome)((Object)((Object)outcome.apply(annotation))), stepCreator);
        }).collect(Collectors.toList());
    }

    private Method[] allMethods() {
        return this.type.getMethods();
    }

    private <T extends Annotation> Map<Method, T> methodsAnnotatedWith(Class<T> annotationClass) {
        LinkedHashMap<Method, T> annotated = new LinkedHashMap<Method, T>();
        for (Method method : this.allMethods()) {
            T annotation = method.getAnnotation(annotationClass);
            if (annotation == null) continue;
            annotated.put(method, annotation);
        }
        return annotated;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append(this.instance()).toString();
    }
}

