/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.operations;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.Future;
import javax.batch.operations.JobExecutionAlreadyCompleteException;
import javax.batch.operations.JobExecutionIsRunningException;
import javax.batch.operations.JobExecutionNotMostRecentException;
import javax.batch.operations.JobExecutionNotRunningException;
import javax.batch.operations.JobOperator;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.JobStartException;
import javax.batch.operations.NoSuchJobException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.operations.NoSuchJobInstanceException;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.StepExecution;
import javax.naming.NamingException;
import org.jberet.creation.ArchiveXmlLoader;
import org.jberet.creation.ArtifactFactoryWrapper;
import org.jberet.job.model.Job;
import org.jberet.repository.JobRepository;
import org.jberet.repository.JobRepositoryFactory;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.JobInstanceImpl;
import org.jberet.runtime.context.JobContextImpl;
import org.jberet.runtime.runner.JobExecutionRunner;
import org.jberet.spi.ArtifactFactory;
import org.jberet.spi.BatchEnvironment;
import org.jberet.util.BatchLogger;

public class JobOperatorImpl
implements JobOperator {
    final JobRepository repository;
    private BatchEnvironment batchEnvironment;
    private final ArtifactFactory artifactFactory;

    public JobOperatorImpl() {
        ServiceLoader<BatchEnvironment> serviceLoader = ServiceLoader.load(BatchEnvironment.class);
        Iterator<BatchEnvironment> it = serviceLoader.iterator();
        if (it.hasNext()) {
            this.batchEnvironment = it.next();
        }
        this.artifactFactory = new ArtifactFactoryWrapper(this.batchEnvironment.getArtifactFactory());
        this.repository = JobRepositoryFactory.getJobRepository(this.batchEnvironment);
    }

    public long start(String jobXMLName, Properties jobParameters) throws JobStartException, JobSecurityException {
        ClassLoader classLoader = this.batchEnvironment.getClassLoader();
        Job jobDefined = ArchiveXmlLoader.loadJobXml(jobXMLName, Job.class, classLoader);
        this.repository.addJob(jobDefined);
        JobInstanceImpl jobInstance = this.repository.createJobInstance(jobDefined, this.getApplicationName(), classLoader);
        return this.startJobExecution(jobInstance, jobParameters, null);
    }

    public void stop(long executionId) throws NoSuchJobExecutionException, JobExecutionNotRunningException, JobSecurityException {
        JobExecutionImpl jobExecution = (JobExecutionImpl)this.repository.getJobExecution(executionId);
        if (jobExecution == null) {
            throw BatchLogger.LOGGER.noSuchJobExecution(executionId);
        }
        BatchStatus s = jobExecution.getBatchStatus();
        if (s == BatchStatus.STOPPED || s == BatchStatus.FAILED || s == BatchStatus.ABANDONED || s == BatchStatus.COMPLETED) {
            throw BatchLogger.LOGGER.jobExecutionNotRunningException(executionId, s);
        }
        if (s != BatchStatus.STOPPING) {
            jobExecution.setBatchStatus(BatchStatus.STOPPING);
            jobExecution.stop();
        }
    }

    public Set<String> getJobNames() throws JobSecurityException {
        HashSet<String> result = new HashSet<String>();
        for (Job e : this.repository.getJobs()) {
            result.add(e.getId());
        }
        return result;
    }

    public int getJobInstanceCount(String jobName) throws NoSuchJobException, JobSecurityException {
        int count = 0;
        for (JobInstance e : this.repository.getJobInstances()) {
            if (!e.getJobName().equals(jobName)) continue;
            ++count;
        }
        if (count == 0) {
            throw BatchLogger.LOGGER.noSuchJobException(jobName);
        }
        return count;
    }

    public List<JobInstance> getJobInstances(String jobName, int start, int count) throws NoSuchJobException, JobSecurityException {
        LinkedList<JobInstance> result = new LinkedList<JobInstance>();
        int pos = 0;
        List<JobInstance> instances = this.repository.getJobInstances();
        for (int i = instances.size() - 1; i >= 0; --i) {
            JobInstance e = instances.get(i);
            if (!e.getJobName().equals(jobName)) continue;
            if (pos >= start) {
                if (result.size() >= count) break;
                result.add(e);
            }
            ++pos;
        }
        if (pos == 0) {
            throw BatchLogger.LOGGER.noSuchJobException(jobName);
        }
        return result;
    }

    public List<Long> getRunningExecutions(String jobName) throws NoSuchJobException, JobSecurityException {
        ArrayList<Long> result = new ArrayList<Long>();
        boolean jobExists = false;
        for (JobExecution e : this.repository.getJobExecutions()) {
            BatchStatus s = e.getBatchStatus();
            if (!e.getJobName().equals(jobName)) continue;
            jobExists = true;
            if (s != BatchStatus.STARTING && s != BatchStatus.STARTED) continue;
            result.add(e.getExecutionId());
        }
        if (!jobExists) {
            throw BatchLogger.LOGGER.noSuchJobException(jobName);
        }
        return result;
    }

    public Properties getParameters(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        return this.getJobExecution(executionId).getJobParameters();
    }

    public long restart(long executionId, Properties restartParameters) throws JobExecutionAlreadyCompleteException, NoSuchJobExecutionException, JobExecutionNotMostRecentException, JobRestartException, JobSecurityException {
        long newExecutionId = 0L;
        JobExecutionImpl originalToRestart = (JobExecutionImpl)this.getJobExecution(executionId);
        if (originalToRestart == null) {
            throw BatchLogger.LOGGER.noSuchJobExecution(executionId);
        }
        BatchStatus previousStatus = originalToRestart.getBatchStatus();
        if (previousStatus == BatchStatus.COMPLETED) {
            throw BatchLogger.LOGGER.jobExecutionAlreadyCompleteException(executionId);
        }
        if (previousStatus == BatchStatus.ABANDONED || previousStatus == BatchStatus.STARTED || previousStatus == BatchStatus.STARTING || previousStatus == BatchStatus.STOPPING) {
            throw BatchLogger.LOGGER.jobRestartException(executionId, previousStatus);
        }
        if (previousStatus == BatchStatus.FAILED || previousStatus == BatchStatus.STOPPED) {
            JobInstanceImpl jobInstance = (JobInstanceImpl)this.getJobInstance(executionId);
            List<JobExecution> executions = jobInstance.getJobExecutions();
            JobExecution mostRecentExecution = executions.get(executions.size() - 1);
            if (executionId != mostRecentExecution.getExecutionId()) {
                throw BatchLogger.LOGGER.jobExecutionNotMostRecentException(executionId, jobInstance.getInstanceId());
            }
            try {
                newExecutionId = this.startJobExecution(jobInstance, restartParameters, originalToRestart);
            }
            catch (Exception e) {
                throw new JobRestartException((Throwable)e);
            }
        }
        return newExecutionId;
    }

    public void abandon(long executionId) throws NoSuchJobExecutionException, JobExecutionIsRunningException, JobSecurityException {
        JobExecutionImpl jobExecution = (JobExecutionImpl)this.getJobExecution(executionId);
        if (jobExecution == null) {
            throw BatchLogger.LOGGER.noSuchJobExecution(executionId);
        }
        BatchStatus batchStatus = jobExecution.getBatchStatus();
        if (batchStatus != BatchStatus.COMPLETED && batchStatus != BatchStatus.FAILED && batchStatus != BatchStatus.STOPPED && batchStatus != BatchStatus.ABANDONED) {
            throw BatchLogger.LOGGER.jobExecutionIsRunningException(executionId);
        }
        jobExecution.setBatchStatus(BatchStatus.ABANDONED);
    }

    public JobInstance getJobInstance(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        JobExecutionImpl jobExecution = (JobExecutionImpl)this.getJobExecution(executionId);
        return jobExecution.getJobInstance();
    }

    public List<JobExecution> getJobExecutions(JobInstance instance) throws NoSuchJobInstanceException, JobSecurityException {
        return ((JobInstanceImpl)instance).getJobExecutions();
    }

    public JobExecution getJobExecution(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        return this.repository.getJobExecution(executionId);
    }

    public List<StepExecution> getStepExecutions(long jobExecutionId) throws NoSuchJobExecutionException, JobSecurityException {
        JobExecutionImpl jobExecution = (JobExecutionImpl)this.getJobExecution(jobExecutionId);
        return jobExecution.getStepExecutions();
    }

    private long startJobExecution(JobInstanceImpl jobInstance, Properties jobParameters, JobExecutionImpl originalToRestart) throws JobStartException, JobSecurityException {
        JobExecutionImpl jobExecution = this.repository.createJobExecution(jobInstance, jobParameters);
        JobContextImpl jobContext = new JobContextImpl(jobExecution, originalToRestart, this.artifactFactory, this.repository, this.batchEnvironment);
        JobExecutionRunner jobExecutionRunner = new JobExecutionRunner(jobContext);
        Future<?> result = jobContext.getBatchEnvironment().getExecutorService().submit(jobExecutionRunner);
        long jobExecutionId = jobExecution.getExecutionId();
        return jobExecutionId;
    }

    private String getApplicationName() {
        try {
            return (String)this.batchEnvironment.lookup("java:app/AppName");
        }
        catch (NamingException e) {
            return null;
        }
    }
}

