/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.job.model;

import java.util.HashMap;
import java.util.Map;

public enum XmlElement {
    UNKNOWN(null),
    ANALYZER("analyzer"),
    BATCHLET("batchlet"),
    CHECKPOINT_ALGORITHM("checkpoint-algorithm"),
    CHUNK("chunk"),
    COLLECTOR("collector"),
    DECISION("decision"),
    END("end"),
    EXCLUDE("exclude"),
    FAIL("fail"),
    FLOW("flow"),
    INCLUDE("include"),
    JOB("job"),
    LISTENER("listener"),
    LISTENERS("listeners"),
    MAPPER("mapper"),
    NEXT("next"),
    NO_ROLLBACK_EXCEPTION_CLASSES("no-rollback-exception-classes"),
    PARTITION("partition"),
    PLAN("plan"),
    PROCESSOR("processor"),
    PROPERTIES("properties"),
    PROPERTY("property"),
    READER("reader"),
    REDUCER("reducer"),
    RETRYABLE_EXCEPTION_CLASSES("retryable-exception-classes"),
    SKIPPABLE_EXCEPTION_CLASSES("skippable-exception-classes"),
    SPLIT("split"),
    STEP("step"),
    STOP("stop"),
    WRITER("writer"),
    BATCH_ARTIFACTS("batch-artifacts"),
    REF("ref");

    private final String name;
    private static final Map<String, XmlElement> MAP;

    private XmlElement(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static XmlElement forName(String localName) {
        XmlElement element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, XmlElement> map = new HashMap<String, XmlElement>();
        for (XmlElement element : XmlElement.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

