/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.Metric;
import javax.batch.runtime.StepExecution;
import org.jberet._private.BatchLogger;
import org.jberet.runtime.AbstractExecution;
import org.jberet.runtime.metric.StepMetrics;

public final class StepExecutionImpl
extends AbstractExecution
implements StepExecution,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private long id;
    private int partitionId = -1;
    private String stepName;
    private Serializable persistentUserData;
    private Serializable readerCheckpointInfo;
    private Serializable writerCheckpointInfo;
    private Exception exception;
    private StepMetrics stepMetrics = new StepMetrics();
    private List<StepExecutionImpl> partitionExecutions = new ArrayList<StepExecutionImpl>();

    public StepExecutionImpl(String stepName) {
        this.stepName = stepName;
        this.startTime = System.currentTimeMillis();
    }

    public StepExecutionImpl(long id, String stepName, Timestamp startTime, Timestamp endTime, String batchStatus, String exitStatus, Serializable persistentUserData, long readCount, long writeCount, long commitCount, long rollbackCount, long readSkipCount, long processSkipCount, long filterCount, long writeSkipCount, Serializable readerCheckpointInfo, Serializable writerCheckpointInfo) {
        this.id = id;
        this.stepName = stepName;
        if (startTime != null) {
            this.startTime = startTime.getTime();
        }
        if (endTime != null) {
            this.endTime = endTime.getTime();
        }
        this.batchStatus = Enum.valueOf(BatchStatus.class, batchStatus);
        this.exitStatus = exitStatus;
        this.persistentUserData = persistentUserData;
        this.readerCheckpointInfo = readerCheckpointInfo;
        this.writerCheckpointInfo = writerCheckpointInfo;
        this.stepMetrics.set(Metric.MetricType.READ_COUNT, readCount);
        this.stepMetrics.set(Metric.MetricType.WRITE_COUNT, writeCount);
        this.stepMetrics.set(Metric.MetricType.COMMIT_COUNT, commitCount);
        this.stepMetrics.set(Metric.MetricType.ROLLBACK_COUNT, rollbackCount);
        this.stepMetrics.set(Metric.MetricType.READ_SKIP_COUNT, readSkipCount);
        this.stepMetrics.set(Metric.MetricType.PROCESS_SKIP_COUNT, processSkipCount);
        this.stepMetrics.set(Metric.MetricType.FILTER_COUNT, filterCount);
        this.stepMetrics.set(Metric.MetricType.WRITE_SKIP_COUNT, writeSkipCount);
    }

    public StepExecutionImpl(int partitionId, long stepExecutionId, BatchStatus batchStatus, String exitStatus, Serializable persistentUserData, Serializable readerCheckpointInfo, Serializable writerCheckpointInfo) {
        this.partitionId = partitionId;
        this.id = stepExecutionId;
        this.batchStatus = batchStatus;
        this.exitStatus = exitStatus;
        this.persistentUserData = persistentUserData;
        this.readerCheckpointInfo = readerCheckpointInfo;
        this.writerCheckpointInfo = writerCheckpointInfo;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public StepExecutionImpl clone() throws CloneNotSupportedException {
        StepExecutionImpl result = null;
        try {
            result = (StepExecutionImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            BatchLogger.LOGGER.failToClone(e, this, "", this.stepName);
        }
        result.partitionId = 0;
        result.partitionExecutions = null;
        result.stepMetrics = new StepMetrics();
        return result;
    }

    public long getStepExecutionId() {
        return this.id;
    }

    public String getStepName() {
        return this.stepName;
    }

    public Serializable getPersistentUserData() {
        return this.persistentUserData;
    }

    public void setPersistentUserData(Serializable persistentUserData) {
        this.persistentUserData = persistentUserData;
    }

    public Metric[] getMetrics() {
        return this.stepMetrics.getMetrics();
    }

    public StepMetrics getStepMetrics() {
        return this.stepMetrics;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    @Override
    public void setBatchStatus(BatchStatus batchStatus) {
        super.setBatchStatus(batchStatus);
        if (batchStatus == BatchStatus.COMPLETED || batchStatus == BatchStatus.FAILED || batchStatus == BatchStatus.STOPPED) {
            this.endTime = System.currentTimeMillis();
        }
    }

    public Serializable getReaderCheckpointInfo() {
        return this.readerCheckpointInfo;
    }

    public void setReaderCheckpointInfo(Serializable readerCheckpointInfo) {
        this.readerCheckpointInfo = readerCheckpointInfo;
    }

    public Serializable getWriterCheckpointInfo() {
        return this.writerCheckpointInfo;
    }

    public void setWriterCheckpointInfo(Serializable writerCheckpointInfo) {
        this.writerCheckpointInfo = writerCheckpointInfo;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(int partitionId) {
        this.partitionId = partitionId;
    }

    public List<StepExecutionImpl> getPartitionExecutions() {
        return this.partitionExecutions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StepExecutionImpl)) {
            return false;
        }
        StepExecutionImpl that = (StepExecutionImpl)o;
        if (this.id != that.id) {
            return false;
        }
        return this.partitionId == that.partitionId;
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + this.partitionId;
        return result;
    }
}

