/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime.runner;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.batch.api.Decider;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.StepExecution;
import org.jberet._private.BatchLogger;
import org.jberet._private.BatchMessages;
import org.jberet.job.model.Decision;
import org.jberet.job.model.Flow;
import org.jberet.job.model.JobElement;
import org.jberet.job.model.Split;
import org.jberet.job.model.Step;
import org.jberet.runtime.context.AbstractContext;
import org.jberet.runtime.context.FlowContextImpl;
import org.jberet.runtime.context.SplitContextImpl;
import org.jberet.runtime.context.StepContextImpl;
import org.jberet.runtime.runner.AbstractRunner;
import org.jberet.runtime.runner.FlowExecutionRunner;
import org.jberet.runtime.runner.SplitExecutionRunner;
import org.jberet.runtime.runner.StepExecutionRunner;

public abstract class CompositeExecutionRunner<C extends AbstractContext>
extends AbstractRunner<C> {
    protected CompositeExecutionRunner(C batchContext, CompositeExecutionRunner enclosingRunner) {
        super(batchContext, enclosingRunner);
    }

    protected abstract List<? extends JobElement> getJobElements();

    protected void runFromHeadOrRestartPoint(String restartPoint) {
        if (restartPoint != null) {
            this.jobContext.getJobExecution().setRestartPosition(null);
            for (JobElement e : this.getJobElements()) {
                if (e instanceof Step) {
                    Step step = (Step)e;
                    if (!step.getId().equals(restartPoint)) continue;
                    this.runStep(step);
                    break;
                }
                if (e instanceof Flow) {
                    Flow flow = (Flow)e;
                    if (!flow.getId().equals(restartPoint)) continue;
                    this.runFlow(flow, null);
                    break;
                }
                if (e instanceof Split) {
                    Split split = (Split)e;
                    if (!split.getId().equals(restartPoint)) continue;
                    this.runSplit(split);
                    break;
                }
                if (!(e instanceof Decision)) continue;
                Decision decision = (Decision)e;
                if (!decision.getId().equals(restartPoint)) break;
                this.runDecision(decision, new StepExecution[0]);
                break;
            }
        } else {
            for (JobElement e : this.getJobElements()) {
                if (e instanceof Step) {
                    Step step = (Step)e;
                    this.runStep(step);
                    break;
                }
                if (e instanceof Flow) {
                    Flow flow = (Flow)e;
                    this.runFlow(flow, null);
                    break;
                }
                if (e instanceof Split) {
                    Split split = (Split)e;
                    this.runSplit(split);
                    break;
                }
                if (!(e instanceof Decision)) continue;
                Decision decision = (Decision)e;
                this.batchContext.setBatchStatus(BatchStatus.FAILED);
                BatchLogger.LOGGER.decisionCannotBeFirst(decision.getId());
                return;
            }
        }
    }

    protected void runJobElement(String jobElementName, StepExecution ... precedingStepExecutions) {
        if (jobElementName == null) {
            return;
        }
        for (JobElement e : this.getJobElements()) {
            Split split;
            if (e instanceof Step) {
                Step step = (Step)e;
                if (!step.getId().equals(jobElementName)) continue;
                this.runStep(step);
                return;
            }
            if (e instanceof Decision) {
                Decision decision = (Decision)e;
                if (!decision.getId().equals(jobElementName)) continue;
                this.runDecision(decision, precedingStepExecutions);
                return;
            }
            if (e instanceof Flow) {
                Flow flow = (Flow)e;
                if (!flow.getId().equals(jobElementName)) continue;
                this.runFlow(flow, null);
                return;
            }
            if (!(e instanceof Split) || !(split = (Split)e).getId().equals(jobElementName)) continue;
            this.runSplit(split);
            return;
        }
        throw BatchMessages.MESSAGES.unrecognizableJobElement(jobElementName, this.id);
    }

    protected void runStep(Step step) {
        StepContextImpl stepContext = new StepContextImpl(step, AbstractContext.addToContextArray(this.batchContext.getOuterContexts(), this.batchContext));
        StepExecutionRunner stepExecutionRunner = new StepExecutionRunner(stepContext, this);
        if (this.batchContext instanceof FlowContextImpl) {
            ((FlowContextImpl)this.batchContext).getFlowExecution().setLastStepExecution(stepContext.getStepExecution());
        }
        stepExecutionRunner.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runDecision(Decision decision, StepExecution ... precedingStepExecutions) {
        Decider decider = (Decider)this.jobContext.createArtifact(decision.getRef(), null, decision.getProperties(), new StepContextImpl[0]);
        try {
            String newExitStatus = decider.decide(precedingStepExecutions);
            this.batchContext.setExitStatus(newExitStatus);
            String next = this.resolveTransitionElements(decision.getTransitionElements(), null, true);
            this.runJobElement(next, precedingStepExecutions);
        }
        catch (Exception e) {
            try {
                BatchLogger.LOGGER.failToRunJob(e, this.jobContext.getJobName(), decision.getRef(), decider);
                this.batchContext.setBatchStatus(BatchStatus.FAILED);
            }
            catch (Throwable throwable) {
                this.jobContext.destroyArtifact(decider);
                throw throwable;
            }
            this.jobContext.destroyArtifact(decider);
        }
        this.jobContext.destroyArtifact(decider);
    }

    protected void runFlow(Flow flow, CountDownLatch latch) {
        FlowContextImpl flowContext;
        AbstractContext[] outerContextsToUse = AbstractContext.addToContextArray(this.batchContext.getOuterContexts(), this.batchContext);
        if (this.batchContext instanceof SplitContextImpl) {
            SplitContextImpl splitContext = (SplitContextImpl)this.batchContext;
            outerContextsToUse[0] = splitContext.getJobContext().clone();
            flowContext = new FlowContextImpl(flow, outerContextsToUse);
            splitContext.getFlowExecutions().add(flowContext.getFlowExecution());
        } else {
            flowContext = new FlowContextImpl(flow, outerContextsToUse);
        }
        FlowExecutionRunner flowExecutionRunner = new FlowExecutionRunner(flowContext, this, latch);
        if (latch != null) {
            this.jobContext.getBatchEnvironment().submitTask(flowExecutionRunner);
        } else {
            flowExecutionRunner.run();
        }
    }

    protected void runSplit(Split split) {
        SplitContextImpl splitContext = new SplitContextImpl(split, AbstractContext.addToContextArray(this.batchContext.getOuterContexts(), this.batchContext));
        SplitExecutionRunner splitExecutionRunner = new SplitExecutionRunner(splitContext, this);
        splitExecutionRunner.run();
    }
}

