/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.batch.operations.JobStartException;
import org.jberet.job.model.Flow;
import org.jberet.job.model.Job;
import org.jberet.job.model.Step;
import org.jboss.marshalling.cloner.ClonerConfiguration;
import org.jboss.marshalling.cloner.ObjectCloner;
import org.jboss.marshalling.cloner.ObjectClonerFactory;
import org.jboss.marshalling.cloner.ObjectCloners;

public class BatchUtil {
    public static final String NL = BatchUtil.getSystemProperty("line.separator");
    private static final String keyValDelimiter = " = ";
    private static final ObjectClonerFactory clonerFactory = ObjectCloners.getSerializingObjectClonerFactory();
    private static final ObjectCloner cloner = clonerFactory.createCloner(new ClonerConfiguration());

    public static String propertiesToString(Properties properties) {
        if (properties == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String key : properties.stringPropertyNames()) {
            sb.append(key).append(keyValDelimiter).append(properties.getProperty(key)).append(NL);
        }
        return sb.toString();
    }

    public static Properties stringToProperties(String content) {
        Properties result = new Properties();
        if (content == null || content.isEmpty()) {
            return result;
        }
        StringTokenizer st = new StringTokenizer(content, NL);
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            int delimiterPos = line.indexOf(keyValDelimiter);
            if (delimiterPos <= 0) continue;
            result.setProperty(line.substring(0, delimiterPos), line.substring(delimiterPos + keyValDelimiter.length()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] objectToBytes(Object obj) throws IOException {
        if (obj == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(bos);
            out.writeObject(obj);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                bos.close();
            }
            catch (IOException e2) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Serializable bytesToSerializableObject(byte[] bytes) throws IOException, ClassNotFoundException {
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(bis);
            Serializable serializable = (Serializable)in.readObject();
            return serializable;
        }
        finally {
            try {
                bis.close();
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e2) {}
        }
    }

    public static StringBuilder toElementSequence(List<?> elements) {
        StringBuilder sb = new StringBuilder();
        for (Object e : elements) {
            if (e instanceof Step) {
                sb.append(((Step)e).getId());
            } else if (e instanceof Job) {
                sb.append(((Job)e).getId());
            } else if (e instanceof Flow) {
                sb.append(((Flow)e).getId());
            }
            sb.append(" -> ");
        }
        return sb;
    }

    public static <T> T clone(T original) throws JobStartException {
        if (original == null) {
            return null;
        }
        try {
            cloner.reset();
            return (T)cloner.clone(original);
        }
        catch (IOException e) {
            throw new JobStartException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new JobStartException((Throwable)e);
        }
    }

    private static String getSystemProperty(final String key) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(key);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key);
            }
        });
    }
}

