/*
DROP    TABLE PARTITION_EXECUTION;

DROP  TRIGGER STEP_EXECUTION_BRI;
DROP SEQUENCE STEP_EXECUTION_SEQ;
DROP    TABLE STEP_EXECUTION;

DROP  TRIGGER JOB_EXECUTION_BRI;
DROP SEQUENCE JOB_EXECUTION_SEQ;
DROP    TABLE JOB_EXECUTION;

DROP  TRIGGER JOB_INSTANCE_BRI;
DROP SEQUENCE JOB_INSTANCE_SEQ;
DROP    TABLE JOB_INSTANCE;
*/

CREATE TABLE JOB_INSTANCE (
  JOBINSTANCEID   NUMBER(19) PRIMARY KEY,
  VERSION         INTEGER,
  JOBNAME         VARCHAR(512),
  APPLICATIONNAME VARCHAR(512)
)!!
CREATE SEQUENCE JOB_INSTANCE_SEQ!!
CREATE OR REPLACE TRIGGER JOB_INSTANCE_BRI
BEFORE INSERT ON JOB_INSTANCE
FOR EACH ROW
  BEGIN
    SELECT JOB_INSTANCE_SEQ.nextval INTO :new.JOBINSTANCEID FROM dual;
  END;!!

CREATE TABLE JOB_EXECUTION (
  JOBEXECUTIONID  NUMBER(19) PRIMARY KEY,
  JOBINSTANCEID   NUMBER(19) NOT NULL,
  VERSION         INTEGER,
  CREATETIME      TIMESTAMP,
  STARTTIME       TIMESTAMP,
  ENDTIME         TIMESTAMP,
  LASTUPDATEDTIME TIMESTAMP,
  BATCHSTATUS     VARCHAR(30),
  EXITSTATUS      VARCHAR(512),
  JOBPARAMETERS   VARCHAR(3000),
  RESTARTPOSITION VARCHAR(255),
  FOREIGN KEY (JOBINSTANCEID) REFERENCES JOB_INSTANCE (JOBINSTANCEID)
)!!
CREATE SEQUENCE JOB_EXECUTION_SEQ!!
CREATE OR REPLACE TRIGGER JOB_EXECUTION_BRI
BEFORE INSERT ON JOB_EXECUTION
FOR EACH ROW
  BEGIN
    SELECT JOB_EXECUTION_SEQ.nextval INTO :new.JOBEXECUTIONID FROM dual;
  END;!!

CREATE TABLE STEP_EXECUTION (
  STEPEXECUTIONID    NUMBER(19) PRIMARY KEY,
  JOBEXECUTIONID     NUMBER(19) NOT NULL,
  VERSION            INTEGER,
  STEPNAME           VARCHAR(255),
  STARTTIME          TIMESTAMP,
  ENDTIME            TIMESTAMP,
  BATCHSTATUS        VARCHAR(30),
  EXITSTATUS         VARCHAR(512),
  EXECUTIONEXCEPTION VARCHAR(2048),
  PERSISTENTUSERDATA BLOB,
  READCOUNT          INTEGER,
  WRITECOUNT         INTEGER,
  COMMITCOUNT        INTEGER,
  ROLLBACKCOUNT      INTEGER,
  READSKIPCOUNT      INTEGER,
  PROCESSSKIPCOUNT   INTEGER,
  FILTERCOUNT        INTEGER,
  WRITESKIPCOUNT     INTEGER,
  READERCHECKPOINTINFO  BLOB,
  WRITERCHECKPOINTINFO  BLOB,
  FOREIGN KEY (JOBEXECUTIONID) REFERENCES JOB_EXECUTION (JOBEXECUTIONID)
)!!
CREATE SEQUENCE STEP_EXECUTION_SEQ!!
CREATE OR REPLACE TRIGGER STEP_EXECUTION_BRI
BEFORE INSERT ON STEP_EXECUTION
FOR EACH ROW
  BEGIN
    SELECT STEP_EXECUTION_SEQ.nextval INTO :new.STEPEXECUTIONID FROM dual;
  END;!!

CREATE TABLE PARTITION_EXECUTION (
  PARTITIONEXECUTIONID  INTEGER NOT NULL,
  STEPEXECUTIONID       NUMBER(19)  NOT NULL,
  VERSION               INTEGER,
  BATCHSTATUS           VARCHAR(30),
  EXITSTATUS            VARCHAR(512),
  EXECUTIONEXCEPTION    VARCHAR(2048),
  PERSISTENTUSERDATA    BLOB,
  READERCHECKPOINTINFO  BLOB,
  WRITERCHECKPOINTINFO  BLOB,
  PRIMARY KEY (PARTITIONEXECUTIONID, STEPEXECUTIONID),
  FOREIGN KEY (STEPEXECUTIONID) REFERENCES STEP_EXECUTION (STEPEXECUTIONID)
)!!
