/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime.runner;

import javax.batch.api.Batchlet;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.jberet.job.model.Properties;
import org.jberet.job.model.Script;
import org.jberet.runtime.context.StepContextImpl;

class ScriptBatchlet
implements Batchlet {
    private final Script script;
    private final Properties artifactProperties;
    private final StepContextImpl stepContext;
    private final ScriptEngine engine;
    private CompiledScript compiledScript;
    private final String scriptContent;

    public ScriptBatchlet(Script script, Properties artifactProperties, StepContextImpl stepContext) throws ScriptException {
        this.script = script;
        this.artifactProperties = artifactProperties;
        this.stepContext = stepContext;
        ClassLoader classLoader = stepContext.getClassLoader();
        this.scriptContent = script.getContent(classLoader);
        this.engine = script.getEngine(classLoader);
        this.setEngineScopeAttributes();
        if (this.engine instanceof Compilable) {
            this.compiledScript = ((Compilable)((Object)this.engine)).compile(this.scriptContent);
        }
    }

    public String process() throws Exception {
        Object result;
        Object object = result = this.compiledScript == null ? this.engine.eval(this.scriptContent) : this.compiledScript.eval();
        if (this.engine instanceof Invocable) {
            Invocable invocable = (Invocable)((Object)this.engine);
            try {
                result = invocable.invokeFunction("process", new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return result == null ? null : result.toString();
    }

    public void stop() throws Exception {
        if (this.engine instanceof Invocable) {
            try {
                ((Invocable)((Object)this.engine)).invokeFunction("stop", new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    private void setEngineScopeAttributes() {
        ScriptContext scriptContext = this.engine.getContext();
        scriptContext.setAttribute("jobContext", this.stepContext.getJobContext(), 100);
        scriptContext.setAttribute("stepContext", this.stepContext, 100);
        scriptContext.setAttribute("batchProperties", Properties.toJavaUtilProperties(this.artifactProperties), 100);
    }
}

