/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.activemq.artemis.wildfly.integration.recovery;

import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.service.extensions.xa.recovery.XARecoveryConfig;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.w3c.dom.Node;

@MessageLogger(projectCode="AMQ")
public interface WildFlyActiveMQLogger
extends BasicLogger {
    public static final WildFlyActiveMQLogger LOGGER = (WildFlyActiveMQLogger)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), WildFlyActiveMQLogger.class, (String)"org.jboss.activemq.artemis.wildfly.integration.recovery");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=121003, value="JMS Server Manager Running cached command for {0}", format=Message.Format.MESSAGE_FORMAT)
    public void serverRunningCachedCommand(Runnable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=121004, value="JMS Server Manager Caching command for {0} since the JMS Server is not active yet", format=Message.Format.MESSAGE_FORMAT)
    public void serverCachingCommand(Object var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=121005, value="Invalid \"host\" value \"0.0.0.0\" detected for \"{0}\" connector. Switching to \"{1}\". If this new address is incorrect please manually configure the connector to use the proper one.", format=Message.Format.MESSAGE_FORMAT)
    public void invalidHostForConnector(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=122007, value="Queue {0} does not exist on the topic {1}. It was deleted manually probably.", format=Message.Format.MESSAGE_FORMAT)
    public void noQueueOnTopic(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=122008, value="XA Recovery can not connect to any ActiveMQ server on recovery {0}", format=Message.Format.MESSAGE_FORMAT)
    public void recoveryConnectFailed(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=122011, value="error unbinding {0} from JNDI", format=Message.Format.MESSAGE_FORMAT)
    public void jndiUnbindError(@Cause Exception var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=122012, value="JMS Server Manager error", format=Message.Format.MESSAGE_FORMAT)
    public void jmsServerError(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=122013, value="Error in XA Recovery recover", format=Message.Format.MESSAGE_FORMAT)
    public void xaRecoverError(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=122014, value="Notified of connection failure in xa recovery connectionFactory for provider {0} will attempt reconnect on next pass", format=Message.Format.MESSAGE_FORMAT)
    public void xaRecoverConnectionError(@Cause Exception var1, ClientSessionFactory var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=122015, value="Can not connect to {0} on auto-generated resource recovery", format=Message.Format.MESSAGE_FORMAT)
    public void xaRecoverAutoConnectionError(@Cause Throwable var1, XARecoveryConfig var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=122016, value="Error in XA Recovery", format=Message.Format.MESSAGE_FORMAT)
    public void xaRecoveryError(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=122017, value="Tried to correct invalid \"host\" value \"0.0.0.0\" for \"{0}\" connector, but received an exception.", format=Message.Format.MESSAGE_FORMAT)
    public void failedToCorrectHost(@Cause Exception var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=122018, value="Could not start recovery discovery on {0}, we will retry every recovery scan until the server is available", format=Message.Format.MESSAGE_FORMAT)
    public void xaRecoveryStartError(XARecoveryConfig var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=124000, value="key attribute missing for JMS configuration {0}", format=Message.Format.MESSAGE_FORMAT)
    public void jmsConfigMissingKey(Node var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=124002, value="Failed to start JMS deployer", format=Message.Format.MESSAGE_FORMAT)
    public void jmsDeployerStartError(@Cause Exception var1);
}

