/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.framework;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jboss.arquillian.ajocado.browser.BrowserType;
import org.jboss.arquillian.ajocado.css.CssResolver;
import org.jboss.arquillian.ajocado.framework.ExtendedSelenium;
import org.jboss.arquillian.ajocado.framework.ExtendedTypedSelenium;
import org.jboss.arquillian.ajocado.framework.TypedSeleniumImpl;
import org.jboss.arquillian.ajocado.geometry.Point;
import org.jboss.arquillian.ajocado.locator.attribute.AttributeLocator;
import org.jboss.arquillian.ajocado.locator.element.ElementLocationStrategy;
import org.jboss.arquillian.ajocado.locator.element.ElementLocator;
import org.jboss.arquillian.ajocado.locator.element.IterableLocator;

public class ExtendedTypedSeleniumImpl
extends TypedSeleniumImpl
implements ExtendedTypedSelenium {
    private boolean started = false;

    protected ExtendedSelenium getExtendedSelenium() {
        if (this.selenium instanceof ExtendedSelenium) {
            return (ExtendedSelenium)this.selenium;
        }
        throw new UnsupportedOperationException("Assigned Selenium isn't instance of ExtendedSelenium");
    }

    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void start() {
        List<String> parameters = this.getDerivedParameters();
        this.selenium.start(StringUtils.join(parameters, (String)","));
        this.started = true;
    }

    private List<String> getDerivedParameters() {
        String startParameters;
        LinkedList<String> parameters = new LinkedList<String>();
        if (this.configuration.isSeleniumNetworkTrafficEnabled()) {
            parameters.add("captureNetworkTraffic=true");
        }
        if (BrowserType.GOOGLE_CHROME == this.configuration.getBrowser().getType()) {
            parameters.add("commandLineFlags=--disable-web-security");
        }
        if ((startParameters = this.configuration.getStartParameters()) != null && !startParameters.isEmpty()) {
            parameters.add(startParameters);
        }
        return parameters;
    }

    @Override
    public void stop() {
        super.stop();
        this.started = false;
    }

    public <R, T extends CssResolver<R>> R getStyle(ElementLocator<?> elementLocator, T cssResolver) {
        String propertyValue = this.getExtendedSelenium().getStyle(elementLocator.inSeleniumRepresentation(), cssResolver.getPropertyName());
        return (R)cssResolver.resolveProperty(propertyValue);
    }

    public void scrollIntoView(ElementLocator<?> elementLocator, boolean alignToTop) {
        this.getExtendedSelenium().scrollIntoView(elementLocator.inSeleniumRepresentation(), String.valueOf(alignToTop));
    }

    public void mouseOverAt(ElementLocator<?> elementLocator, Point point) {
        this.getExtendedSelenium().mouseOverAt(elementLocator.inSeleniumRepresentation(), point.inSeleniumRepresentation());
    }

    public void mouseOutAt(ElementLocator<?> elementLocator, Point point) {
        this.getExtendedSelenium().mouseOutAt(elementLocator.inSeleniumRepresentation(), point.inSeleniumRepresentation());
    }

    public boolean belongsClass(ElementLocator<?> elementLocator, String className) {
        return this.getExtendedSelenium().belongsClass(elementLocator.inSeleniumRepresentation(), className);
    }

    public boolean isAttributePresent(AttributeLocator<?> attributeLocator) {
        String elementLocator = attributeLocator.getAssociatedElement().inSeleniumRepresentation();
        String attributeName = attributeLocator.getAttribute().getAttributeName();
        return this.getExtendedSelenium().isAttributePresent(elementLocator, attributeName);
    }

    @Override
    public int getCount(IterableLocator<?> locator) {
        if (locator.getLocationStrategy() == ElementLocationStrategy.JQUERY) {
            return this.getExtendedSelenium().getJQueryCount(locator.getRawLocator()).intValue();
        }
        try {
            return super.getCount(locator);
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedOperationException("Only JQuery and XPath locators are supported for counting");
        }
    }

    public void check(ElementLocator<?> locator, boolean checked) {
        if (checked) {
            this.check(locator);
        } else {
            this.uncheck(locator);
        }
    }

    public void doCommand(String command, String param1, String param2) {
        this.getExtendedSelenium().doCommand(command, param1, param2);
    }
}

