/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.guard;

import org.jboss.arquillian.ajocado.framework.AjaxSelenium;
import org.jboss.arquillian.ajocado.framework.AjaxSeleniumContext;
import org.jboss.arquillian.ajocado.framework.AjocadoConfiguration;
import org.jboss.arquillian.ajocado.framework.AjocadoConfigurationContext;
import org.jboss.arquillian.ajocado.guard.RequestGuard;
import org.jboss.arquillian.ajocado.javascript.JavaScript;
import org.jboss.arquillian.ajocado.request.RequestType;

public class RequestGuardImpl
implements RequestGuard {
    private static final String WAIT_FOR_REQUEST = "waitForRequest";
    private static final JavaScript CLEAR_REQUEST_DONE = JavaScript.js((String)"Ajocado.RequestInterceptor.clearRequestDone()");
    private static final JavaScript GET_REQUEST_DONE = JavaScript.js((String)"Ajocado.RequestInterceptor.getRequestDone()");
    private AjaxSelenium selenium = AjaxSeleniumContext.getProxy();
    private AjocadoConfiguration configuration = AjocadoConfigurationContext.getProxy();

    public RequestType getRequestDone() {
        String requestDone = this.selenium.getEval(GET_REQUEST_DONE);
        return this.parseRequest(requestDone);
    }

    public RequestType clearRequestDone() {
        String lastRequest = this.selenium.getEval(CLEAR_REQUEST_DONE);
        return this.parseRequest(lastRequest);
    }

    public void waitForRequest() {
        this.selenium.doCommand(WAIT_FOR_REQUEST, Long.toString(this.configuration.getTimeout(AjocadoConfiguration.TimeoutType.AJAX)), null);
    }

    private RequestType parseRequest(String request) {
        try {
            return RequestType.valueOf((String)request);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Request was evaluated to unknown type '" + request + "'");
        }
    }
}

