/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.utils;

import java.lang.reflect.Method;

public final class CloneUtils {
    private CloneUtils() {
    }

    public static <T extends Cloneable> T clone(Class<T> type, T objectToClone) {
        Cloneable clone;
        if (!(objectToClone instanceof Cloneable)) {
            throw new IllegalArgumentException("objectToClone have to be instance of Cloneable");
        }
        try {
            Method method = type.getDeclaredMethod("clone", new Class[0]);
            method.setAccessible(true);
            clone = (Cloneable)method.invoke(objectToClone, new Object[0]);
            method.setAccessible(false);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected exception during cloning of " + objectToClone.getClass().getName(), e);
        }
        return (T)clone;
    }
}

