/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.waiting.conditions;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.Validate;
import org.jboss.arquillian.ajocado.framework.AjaxSelenium;
import org.jboss.arquillian.ajocado.framework.AjaxSeleniumContext;
import org.jboss.arquillian.ajocado.javascript.JavaScript;
import org.jboss.arquillian.ajocado.locator.element.ElementLocator;
import org.jboss.arquillian.ajocado.waiting.ajax.JavaScriptCondition;
import org.jboss.arquillian.ajocado.waiting.selenium.SeleniumCondition;

public class ElementPresent
implements SeleniumCondition,
JavaScriptCondition {
    private AjaxSelenium selenium = AjaxSeleniumContext.getProxy();
    private ElementLocator<?> elementLocator;

    protected ElementPresent() {
    }

    @Override
    public boolean isTrue() {
        Validate.notNull(this.elementLocator);
        return this.selenium.isElementPresent(this.elementLocator);
    }

    @Override
    public JavaScript getJavaScriptCondition() {
        String escapedLocator = StringEscapeUtils.escapeJavaScript((String)this.elementLocator.inSeleniumRepresentation());
        return JavaScript.js((String)"selenium.isElementPresent('{0}')").parametrize(new Object[]{escapedLocator});
    }

    public static ElementPresent getInstance() {
        return new ElementPresent();
    }

    public ElementPresent locator(ElementLocator<?> elementLocator) {
        Validate.notNull(elementLocator);
        ElementPresent copy = this.copy();
        copy.elementLocator = elementLocator;
        return copy;
    }

    private ElementPresent copy() {
        ElementPresent copy = new ElementPresent();
        copy.elementLocator = this.elementLocator;
        return copy;
    }
}

