/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jboss.arquillian.impl.Validate;
import org.jboss.arquillian.impl.core.spi.Manager;
import org.jboss.arquillian.impl.core.spi.NonManagedObserver;
import org.jboss.arquillian.spi.LifecycleMethodExecutor;
import org.jboss.arquillian.spi.TestMethodExecutor;
import org.jboss.arquillian.spi.TestResult;
import org.jboss.arquillian.spi.TestRunnerAdaptor;
import org.jboss.arquillian.spi.core.Instance;
import org.jboss.arquillian.spi.core.annotation.Inject;
import org.jboss.arquillian.spi.event.suite.After;
import org.jboss.arquillian.spi.event.suite.AfterClass;
import org.jboss.arquillian.spi.event.suite.AfterSuite;
import org.jboss.arquillian.spi.event.suite.Before;
import org.jboss.arquillian.spi.event.suite.BeforeClass;
import org.jboss.arquillian.spi.event.suite.BeforeSuite;
import org.jboss.arquillian.spi.event.suite.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTestRunnerAdaptor
implements TestRunnerAdaptor {
    private Manager manager;

    public EventTestRunnerAdaptor(Manager manager) {
        Validate.notNull(manager, "Manager must be specified");
        this.manager = manager;
    }

    public void beforeSuite() throws Exception {
        this.manager.fire(new BeforeSuite());
    }

    public void afterSuite() throws Exception {
        this.manager.fire(new AfterSuite());
    }

    public void beforeClass(Class<?> testClass, LifecycleMethodExecutor executor) throws Exception {
        Validate.notNull(testClass, "TestClass must be specified");
        this.manager.fire(new BeforeClass(testClass, executor));
    }

    public void afterClass(Class<?> testClass, LifecycleMethodExecutor executor) throws Exception {
        Validate.notNull(testClass, "TestClass must be specified");
        this.manager.fire(new AfterClass(testClass, executor));
    }

    public void before(Object testInstance, Method testMethod, LifecycleMethodExecutor executor) throws Exception {
        Validate.notNull(testInstance, "TestInstance must be specified");
        Validate.notNull(testMethod, "TestMethod must be specified");
        this.manager.fire(new Before(testInstance, testMethod, executor));
    }

    public void after(Object testInstance, Method testMethod, LifecycleMethodExecutor executor) throws Exception {
        Validate.notNull(testInstance, "TestInstance must be specified");
        Validate.notNull(testMethod, "TestMethod must be specified");
        this.manager.fire(new After(testInstance, testMethod, executor));
    }

    public TestResult test(TestMethodExecutor testMethodExecutor) throws Exception {
        Validate.notNull(testMethodExecutor, "TestMethodExecutor must be specified");
        final ArrayList result = new ArrayList();
        this.manager.fire(new Test(testMethodExecutor), new NonManagedObserver<Test>(){
            @Inject
            private Instance<TestResult> testResult;

            @Override
            public void fired(Test event) {
                result.add(this.testResult.get());
            }
        });
        return (TestResult)result.get(0);
    }

    public void shutdown() {
        this.manager.shutdown();
    }
}

