/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.core;

import java.util.ArrayList;
import java.util.List;
import org.jboss.arquillian.impl.core.ManagerImpl;
import org.jboss.arquillian.impl.core.Validate;
import org.jboss.arquillian.impl.core.spi.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagerBuilder {
    private List<Class<? extends Context>> contexts = new ArrayList<Class<? extends Context>>();
    private List<Class<?>> extensions = new ArrayList();

    public static ManagerBuilder from() {
        return new ManagerBuilder();
    }

    private ManagerBuilder() {
    }

    public ManagerBuilder context(Class<? extends Context> context) {
        Validate.notNull(context, "Context must be specified");
        this.contexts.add(context);
        return this;
    }

    public ManagerBuilder extensions(Class<?> ... extensions) {
        Validate.notNull(extensions, "Extensions must be specified");
        for (Class<?> extension : extensions) {
            this.extension(extension);
        }
        return this;
    }

    public ManagerBuilder extension(Class<?> extension) {
        Validate.notNull(extension, "Extension must be specified");
        this.extensions.add(extension);
        return this;
    }

    public ManagerImpl create() {
        return new ManagerImpl(this.contexts, this.extensions);
    }
}

