/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.test.impl;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.arquillian.container.test.impl.SecurityActions;
import org.jboss.arquillian.container.test.spi.RemoteLoadableExtension;
import org.jboss.arquillian.core.spi.ExtensionLoader;
import org.jboss.arquillian.core.spi.LoadableExtension;
import org.jboss.arquillian.core.spi.Validate;

public class RemoteExtensionLoader
implements ExtensionLoader {
    private static final String SERVICES = "META-INF/services";

    public Collection<LoadableExtension> load() {
        ArrayList<LoadableExtension> extensions = new ArrayList<LoadableExtension>();
        for (RemoteLoadableExtension extension : this.all(SecurityActions.getThreadContextClassLoader(), RemoteLoadableExtension.class)) {
            extensions.add((LoadableExtension)extension);
        }
        return extensions;
    }

    private <T> Collection<T> all(ClassLoader classLoader, Class<T> serviceClass) {
        Validate.notNull((Object)classLoader, (String)"ClassLoader must be provided");
        Validate.notNull(serviceClass, (String)"ServiceClass must be provided");
        return this.createInstances(serviceClass, this.load(serviceClass, classLoader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Set<Class<? extends T>> load(Class<T> serviceClass, ClassLoader loader) {
        String serviceFile = "META-INF/services/" + serviceClass.getName();
        LinkedHashSet<Class<T>> providers = new LinkedHashSet<Class<T>>();
        try {
            Enumeration<URL> enumeration = loader.getResources(serviceFile);
            while (enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                InputStream is = url.openStream();
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    String line = reader.readLine();
                    while (null != line) {
                        int comment = line.indexOf(35);
                        if (comment > -1) {
                            line = line.substring(0, comment);
                        }
                        if ((line = line.trim()).length() > 0) {
                            try {
                                providers.add(loader.loadClass(line).asSubclass(serviceClass));
                            }
                            catch (ClassCastException e) {
                                throw new IllegalStateException("Service " + line + " does not implement expected type " + serviceClass.getName());
                            }
                        }
                        line = reader.readLine();
                    }
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load services for " + serviceClass.getName(), e);
        }
        return providers;
    }

    private <T> T createInstance(Class<? extends T> serviceImplClass) {
        try {
            Constructor<T> constructor = SecurityActions.getConstructor(serviceImplClass, new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create a new instance of Service implementation " + serviceImplClass.getName(), e);
        }
    }

    private <T> Set<T> createInstances(Class<T> serviceType, Set<Class<? extends T>> providers) {
        LinkedHashSet<T> providerImpls = new LinkedHashSet<T>();
        for (Class<T> clazz : providers) {
            providerImpls.add(this.createInstance(clazz));
        }
        return providerImpls;
    }
}

