/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.jbossas.managed_4_2;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.arquillian.container.jbossas.managed_4_2.ArquillianServerManager;
import org.jboss.arquillian.container.jbossas.managed_4_2.JBossASConfiguration;
import org.jboss.arquillian.container.jbossas.managed_4_2.ManagementViewParser;
import org.jboss.arquillian.container.jbossas.managed_4_2.ShrinkWrapUtil;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.jbossas.servermanager.Argument;
import org.jboss.jbossas.servermanager.Property;
import org.jboss.jbossas.servermanager.Server;
import org.jboss.jbossas.servermanager.ServerController;
import org.jboss.jbossas.servermanager.ServerManager;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossASLocalContainer
implements DeployableContainer<JBossASConfiguration> {
    private static final TargetModuleID[] EMPTY_ARRAY = new TargetModuleID[0];
    private JBossASConfiguration configuration;
    private DeploymentManager deploymentManager;
    protected ServerManager serverManager;
    @Inject
    @ContainerScoped
    private InstanceProducer<Context> contextInst;
    private TargetModuleID[] targetModuleIDs = EMPTY_ARRAY;

    public void setup(JBossASConfiguration configuration) {
        this.configuration = configuration;
        this.serverManager = this.createAndConfigureServerManager(configuration);
    }

    public Class<JBossASConfiguration> getConfigurationClass() {
        return JBossASConfiguration.class;
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 2.5");
    }

    public void start() throws LifecycleException {
        try {
            Server server = this.serverManager.getServer(this.configuration.getProfileName());
            if (ServerController.isServerStarted((Server)server)) {
                throw new LifecycleException("The server is already running! Managed containers does not support connecting to running server instances due to the possible harmfull effect of connecting to the wrong server. Please stop server before running or change to another type of container.");
            }
            this.serverManager.startServer(server.getName());
            this.createContext(server);
            this.deploymentManager = this.createDeploymentManager(server);
        }
        catch (Exception e) {
            throw new LifecycleException("Could not connect to container", (Throwable)e);
        }
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        URL deploymentUrl = ShrinkWrapUtil.toURL(descriptor);
        this.deploy(new File(deploymentUrl.getFile()));
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        if (archive == null) {
            throw new IllegalArgumentException("Archive must be specified");
        }
        File deployment = ShrinkWrapUtil.toFile(archive);
        this.targetModuleIDs = this.deploy(deployment);
        try {
            Server server = this.serverManager.getServer(this.configuration.getProfileName());
            return ManagementViewParser.parse(archive.getName(), server.getServerConnection());
        }
        catch (Exception e) {
            throw new DeploymentException("Could not extract deployment metadata", (Throwable)e);
        }
    }

    private Context createContext(Server server) throws NamingException {
        if (this.contextInst.get() == null) {
            this.contextInst.set((Object)server.getNamingContext());
        }
        return (Context)this.contextInst.get();
    }

    private TargetModuleID[] deploy(File deployment) throws DeploymentException {
        ProgressObject progress;
        try {
            File deploymentPlan = ShrinkWrapUtil.createDeploymentPlan(deployment);
            progress = this.deploymentManager.distribute(this.deploymentManager.getTargets(), deployment, deploymentPlan);
        }
        catch (IOException e) {
            throw new DeploymentException("Failed to deploy " + deployment.getName(), (Throwable)e);
        }
        DeploymentStatus status = progress.getDeploymentStatus();
        JBossASLocalContainer.waitForCompletion(status);
        if (status.getState() == StateType.FAILED) {
            throw new DeploymentException("Failed to deploy " + deployment.getName() + ": " + status.getMessage());
        }
        TargetModuleID[] moduleIDs = progress.getResultTargetModuleIDs();
        progress = this.deploymentManager.start(moduleIDs);
        status = progress.getDeploymentStatus();
        JBossASLocalContainer.waitForCompletion(status);
        return progress.getResultTargetModuleIDs();
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        if (archive == null) {
            throw new IllegalArgumentException("Archive must be specified");
        }
        try {
            this.undeploy();
        }
        catch (Exception e) {
            throw new DeploymentException("Could not undeploy " + archive.getName(), (Throwable)e);
        }
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        try {
            this.undeploy();
        }
        catch (Exception e) {
            throw new DeploymentException("Could not undeploy " + descriptor.getDescriptorName(), (Throwable)e);
        }
    }

    private void undeploy() throws DeploymentException {
        if (this.targetModuleIDs.length == 0) {
            return;
        }
        ProgressObject stopProgress = this.deploymentManager.stop(this.targetModuleIDs);
        DeploymentStatus stopStatus = stopProgress.getDeploymentStatus();
        JBossASLocalContainer.waitForCompletion(stopStatus);
        if (this.isNotCompleted(stopStatus)) {
            throw new DeploymentException("Stop deployment not completed: " + stopStatus.getMessage());
        }
        ProgressObject undeployProgress = this.deploymentManager.undeploy(this.targetModuleIDs);
        DeploymentStatus undeployStatus = undeployProgress.getDeploymentStatus();
        JBossASLocalContainer.waitForCompletion(undeployStatus);
        if (this.isNotCompleted(undeployStatus)) {
            throw new DeploymentException("Undeploy not completed: " + undeployStatus.getMessage());
        }
        this.targetModuleIDs = EMPTY_ARRAY;
    }

    public void stop() throws LifecycleException {
        Server server = this.serverManager.getServer(this.configuration.getProfileName());
        if (!server.isRunning()) {
            throw new LifecycleException("Can not stop server. Server is not started");
        }
        try {
            this.serverManager.stopServer(server.getName());
        }
        catch (Exception e) {
            throw new LifecycleException("Could not stop server", (Throwable)e);
        }
    }

    private DeploymentManager createDeploymentManager(Server server) throws DeploymentManagerCreationException {
        DeploymentFactoryManager dfm = DeploymentFactoryManager.getInstance();
        return dfm.getDeploymentManager(server.getServerUrl(), null, null);
    }

    private boolean isNotCompleted(DeploymentStatus status) {
        return StateType.COMPLETED != status.getState();
    }

    private static void waitForCompletion(DeploymentStatus status) throws DeploymentException {
        try {
            while (StateType.RUNNING == status.getState()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            throw new DeploymentException("Failed to deploy: " + e.getMessage());
        }
    }

    private ServerManager createAndConfigureServerManager(JBossASConfiguration configuration) {
        ArquillianServerManager manager = new ArquillianServerManager(configuration.getStartupTimeoutInSeconds(), configuration.getShutdownTimeoutInSeconds());
        if (configuration.getJbossHome() != null) {
            manager.setJbossHome(configuration.getJbossHome());
        }
        if (configuration.getJavaHome() != null) {
            manager.setJavaHome(configuration.getJavaHome());
        }
        manager.addServer(this.createAndConfigureServer(configuration));
        return manager;
    }

    private Server createAndConfigureServer(JBossASConfiguration configuration) {
        Server server = new Server();
        server.setName(configuration.getProfileName());
        server.setHttpPort(Integer.valueOf(configuration.getHttpPort()));
        server.setRmiPort(Integer.valueOf(configuration.getRmiPort()));
        server.setHost(configuration.getBindAddress());
        server.setHasWebServer(!configuration.isUseRmiPortForAliveCheck());
        server.setUsername(configuration.getUsername());
        server.setPassword(configuration.getPassword());
        if (configuration.getPartition() != null) {
            server.setPartition(configuration.getPartition());
        } else {
            server.setPartition(Long.toHexString(System.currentTimeMillis()));
        }
        this.setServerVMArgs(server, configuration.getJavaVmArguments());
        Property prop = new Property();
        prop.setKey("jbosstest.udp.ip_ttl");
        prop.setValue("0");
        server.addSysProperty(prop);
        prop = new Property();
        prop.setKey("java.endorsed.dirs");
        prop.setValue(new File(configuration.getJbossHome(), "lib/endorsed").getAbsolutePath());
        server.addSysProperty(prop);
        return server;
    }

    private void setServerVMArgs(Server server, String arguments) {
        for (String argument : arguments.split(" ")) {
            Argument arg = new Argument();
            arg.setValue(argument);
            server.addJvmArg(arg);
        }
    }
}

