/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.jbossas.managed_4_2;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.jar.JarOutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipOutputStream;
import org.jboss.deployment.spi.DeploymentMetaData;
import org.jboss.deployment.spi.JarUtils;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ShrinkWrapUtil {
    private ShrinkWrapUtil() {
    }

    public static File toFile(Archive<?> archive) {
        try {
            File root = File.createTempFile("arquillian", archive.getName());
            root.delete();
            root.mkdirs();
            File deployment = new File(root, archive.getName());
            deployment.deleteOnExit();
            ((ZipExporter)archive.as(ZipExporter.class)).exportTo(deployment, true);
            return deployment;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not export deployment to temp", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL toURL(Descriptor descriptor) {
        try {
            File root = File.createTempFile("arquillian", descriptor.getDescriptorName());
            root.delete();
            root.mkdirs();
            File deployment = new File(root, descriptor.getDescriptorName());
            deployment.deleteOnExit();
            FileOutputStream stream = new FileOutputStream(deployment);
            try {
                descriptor.exportTo((OutputStream)stream);
            }
            finally {
                try {
                    stream.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return deployment.toURI().toURL();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not export deployment to temp", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createDeploymentPlan(File deployment) throws IOException {
        DeflaterOutputStream jos = null;
        try {
            File deploymentPlan = new File(deployment.getParentFile(), "deploymentplan.zip");
            deploymentPlan.deleteOnExit();
            jos = new JarOutputStream(new FileOutputStream(deploymentPlan));
            DeploymentMetaData metaData = new DeploymentMetaData(deployment.getName());
            String metaStr = metaData.toXMLString();
            JarUtils.addJarEntry((JarOutputStream)jos, (String)"deployment-plan.xml", (InputStream)new ByteArrayInputStream(metaStr.getBytes()));
            File file = deploymentPlan;
            return file;
        }
        finally {
            if (jos != null) {
                jos.flush();
                ((ZipOutputStream)jos).close();
            }
        }
    }
}

