/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.prototyping.context.impl.openejb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.openejb.assembler.classic.AppInfo;
import org.jboss.arquillian.prototyping.context.api.openejb.OpenEJBArquillianContext;
import org.jboss.arquillian.prototyping.context.impl.ArquillianContextResolver;
import org.jboss.arquillian.prototyping.context.impl.BaseContext;
import org.jboss.arquillian.prototyping.context.impl.BaseContextualResolver;
import org.jboss.arquillian.prototyping.context.impl.openejb.OpenEJBJndiContextResolver;
import org.jboss.arquillian.prototyping.context.spi.ContextualResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenEJBArquillianContextImpl
extends BaseContext
implements OpenEJBArquillianContext {
    private static final Logger log = Logger.getLogger(OpenEJBArquillianContextImpl.class.getName());
    private final List<ContextualResolver> resolvers;
    private final AppInfo deployment;

    public OpenEJBArquillianContextImpl(AppInfo deployment) throws IllegalArgumentException {
        if (deployment == null) {
            throw new IllegalArgumentException("deployment must be specified");
        }
        ArrayList<BaseContextualResolver> resolvers = new ArrayList<BaseContextualResolver>();
        resolvers.add(new ArquillianContextResolver(this));
        resolvers.add(OpenEJBJndiContextResolver.getInstance());
        if (log.isLoggable(Level.FINE)) {
            log.fine("Using resolvers: " + resolvers);
        }
        this.resolvers = Collections.unmodifiableList(resolvers);
        this.deployment = deployment;
    }

    @Override
    public <T> T get(Class<T> type, Map<String, Object> properties) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("type must be specified");
        }
        if (properties == null) {
            throw new IllegalArgumentException("properties must be specified");
        }
        for (ContextualResolver resolver : this.resolvers) {
            T resolved = resolver.resolve(type, properties);
            if (resolved == null) continue;
            return resolved;
        }
        return null;
    }

    @Override
    public AppInfo getDeploymentMetadata() {
        return this.deployment;
    }
}

