/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.tomcat;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Base64;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.tomcat.CommonTomcatConfiguration;
import org.jboss.arquillian.container.tomcat.IOUtil;
import org.jboss.arquillian.container.tomcat.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonTomcatManager<C extends CommonTomcatConfiguration> {
    private static Logger log = Logger.getLogger(CommonTomcatManager.class.getName());
    protected static final String MANAGER_CHARSET = "utf-8";
    private C configuration;

    public CommonTomcatManager(C configuration) {
        this.configuration = configuration;
    }

    public void deploy(String name, URL content) throws IOException, DeploymentException {
        String contentType = "application/octet-stream";
        Validate.notNullOrEmpty(name, "Name must not be null or empty");
        Validate.notNull(content, "Content to be deployed must not be null");
        URLConnection conn = content.openConnection();
        int contentLength = conn.getContentLength();
        BufferedInputStream stream = new BufferedInputStream(conn.getInputStream());
        StringBuilder command = new StringBuilder(this.getDeployCommand());
        try {
            command.append(URLEncoder.encode(name, ((CommonTomcatConfiguration)this.configuration).getUrlCharset()));
        }
        catch (UnsupportedEncodingException e) {
            throw new DeploymentException("Unable to construct path for Tomcat manager", (Throwable)e);
        }
        this.execute(command.toString(), stream, "application/octet-stream", contentLength);
    }

    public void undeploy(String name) throws IOException, DeploymentException {
        Validate.notNullOrEmpty(name, "Undeployed name must not be null or empty");
        StringBuilder command = new StringBuilder(this.getUndeployCommand());
        try {
            command.append(URLEncoder.encode(name, ((CommonTomcatConfiguration)this.configuration).getUrlCharset()));
        }
        catch (UnsupportedEncodingException e) {
            throw new DeploymentException("Unable to construct path for Tomcat manager", (Throwable)e);
        }
        this.execute(command.toString(), null, null, -1);
    }

    public void list() throws IOException {
        this.execute(this.getListCommand(), null, null, -1);
    }

    public boolean isRunning() {
        try {
            this.list();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String normalizeArchiveName(String name) {
        Validate.notNull(name, "Archive name must not be empty");
        if ("ROOT.war".equals(name)) {
            return "";
        }
        if (name.indexOf(46) != -1) {
            return name.substring(0, name.lastIndexOf("."));
        }
        return name;
    }

    protected String getDeployCommand() {
        return "/deploy?path=";
    }

    protected String getUndeployCommand() {
        return "/undeploy?path=";
    }

    protected String getListCommand() {
        return "/list";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(String command, InputStream istream, String contentType, int contentLength) throws IOException {
        URLConnection conn = null;
        try {
            conn = new URL(((CommonTomcatConfiguration)this.configuration).getManagerUrl() + command).openConnection();
            HttpURLConnection hconn = (HttpURLConnection)conn;
            hconn.setAllowUserInteraction(false);
            hconn.setDoInput(true);
            hconn.setUseCaches(false);
            if (istream != null) {
                hconn.setDoOutput(true);
                hconn.setRequestMethod("PUT");
                if (contentType != null) {
                    hconn.setRequestProperty("Content-Type", contentType);
                }
                if (contentLength >= 0) {
                    hconn.setRequestProperty("Content-Length", "" + contentLength);
                    hconn.setFixedLengthStreamingMode(contentLength);
                }
            } else {
                hconn.setDoOutput(false);
                hconn.setRequestMethod("GET");
            }
            hconn.setRequestProperty("User-Agent", "Arquillian-Tomcat-Manager-Util/1.0");
            if (((CommonTomcatConfiguration)this.configuration).getUser() != null && ((CommonTomcatConfiguration)this.configuration).getUser().length() != 0) {
                hconn.setRequestProperty("Authorization", this.constructHttpBasicAuthHeader());
            }
            hconn.setRequestProperty("Accept", "text/plain");
            hconn.connect();
            if (istream != null) {
                BufferedOutputStream ostream = new BufferedOutputStream(hconn.getOutputStream(), 1024);
                IOUtil.copy(istream, ostream);
                ostream.flush();
                ostream.close();
                istream.close();
            }
            this.processResponse(command, hconn);
        }
        finally {
            IOUtil.closeQuietly(istream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processResponse(String command, HttpURLConnection hconn) throws IOException {
        int httpResponseCode = hconn.getResponseCode();
        if (httpResponseCode >= 400 && httpResponseCode < 500) {
            throw new ConfigurationException("Unable to connect to Tomcat manager. The server command (" + command + ") failed with responseCode (" + httpResponseCode + ") and responseMessage (" + hconn.getResponseMessage() + ").\n\n" + "Please make sure that you provided correct credentials to an user which is able to access Tomcat manager application.\n" + "These credentials can be specified in the Arquillian container configuration as \"user\" and \"pass\" properties.\n" + "The user must have appripriate role specified in tomcat-users.xml file.\n");
        }
        if (httpResponseCode >= 300) {
            throw new IllegalStateException("The server command (" + command + ") failed with responseCode (" + httpResponseCode + ") and responseMessage (" + hconn.getResponseMessage() + ").");
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(hconn.getInputStream(), MANAGER_CHARSET));
            String line = reader.readLine();
            String contentError = null;
            if (line != null && !line.startsWith("OK -")) {
                contentError = line;
            }
            while (line != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(line);
                }
                line = reader.readLine();
            }
            if (contentError != null) {
                throw new RuntimeException("The server command (" + command + ") failed with content (" + contentError + ").");
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(reader);
            throw throwable;
        }
        IOUtil.closeQuietly(reader);
    }

    protected String constructHttpBasicAuthHeader() {
        String credentials = ((CommonTomcatConfiguration)this.configuration).getUser() + ":" + ((CommonTomcatConfiguration)this.configuration).getPass();
        try {
            return "Basic " + Base64.encodeBase64String((byte[])credentials.getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

