/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.tomcat.embedded_7;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.CatalinaProperties;
import org.apache.catalina.startup.ExpandWar;
import org.apache.catalina.startup.Tomcat;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.container.spi.context.annotation.DeploymentScoped;
import org.jboss.arquillian.container.tomcat.embedded_7.EmbeddedContextConfig;
import org.jboss.arquillian.container.tomcat.embedded_7.SystemPropertiesUtil;
import org.jboss.arquillian.container.tomcat.embedded_7.TomcatConfiguration;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatContainer
implements DeployableContainer<TomcatConfiguration> {
    private static final Logger log = Logger.getLogger(TomcatContainer.class.getName());
    private TomcatConfiguration configuration;
    private Tomcat tomcat;
    private Host host;
    private File appBase;
    private boolean wasStarted;
    private final List<String> failedUndeployments = new ArrayList<String>();
    @Inject
    @DeploymentScoped
    private InstanceProducer<StandardContext> standardContextProducer;
    private final SystemPropertiesUtil systemPropertiesUtil = new SystemPropertiesUtil();

    public Class<TomcatConfiguration> getConfigurationClass() {
        return TomcatConfiguration.class;
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 3.0");
    }

    public void setup(TomcatConfiguration configuration) {
        this.configuration = configuration;
    }

    public void start() throws LifecycleException {
        try {
            File tempDir = this.getTomcatHomeFile();
            System.setProperty("catalina.base", tempDir.getAbsolutePath());
            CatalinaProperties.getProperty((String)"foo");
            this.appBase = new File(tempDir, "webapps");
            if (!this.appBase.exists() && !this.appBase.mkdirs()) {
                throw new LifecycleException("Unable to create appBase " + this.appBase.getAbsolutePath() + " for Tomcat");
            }
            this.tomcat = new Tomcat();
            this.tomcat.getService().setName(this.configuration.getServerName());
            this.tomcat.setHostname(this.configuration.getBindAddress());
            this.tomcat.setPort(this.configuration.getBindHttpPort());
            this.tomcat.setBaseDir(tempDir.getAbsolutePath());
            this.tomcat.enableNaming();
            this.tomcat.getEngine().setName(this.configuration.getServerName());
            this.host = this.tomcat.getHost();
            this.host.setAppBase(this.appBase.getAbsolutePath());
            this.tomcat.start();
            this.wasStarted = true;
        }
        catch (Exception e) {
            throw new LifecycleException("Failed to start embedded Tomcat", (Throwable)e);
        }
    }

    public void stop() throws LifecycleException {
        try {
            this.removeFailedUnDeployments();
        }
        catch (Exception e) {
            throw new LifecycleException("Could not clean up", (Throwable)e);
        }
        if (this.wasStarted) {
            try {
                this.tomcat.stop();
            }
            catch (org.apache.catalina.LifecycleException e) {
                throw new LifecycleException("Failed to stop Tomcat", (Throwable)e);
            }
        }
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        try {
            File archiveFile = new File(this.appBase, archive.getName());
            ((ZipExporter)archive.as(ZipExporter.class)).exportTo(archiveFile, true);
            String baseDir = this.getArchiveNameWithoutExtension(archive);
            String contextPath = "/" + baseDir;
            StandardContext standardContext = (StandardContext)this.workAroundTomcat51526(contextPath, baseDir);
            this.standardContextProducer.set((Object)standardContext);
            HTTPContext httpContext = new HTTPContext(this.configuration.getBindAddress(), this.configuration.getBindHttpPort());
            for (String mapping : standardContext.findServletMappings()) {
                httpContext.add(new Servlet(standardContext.findServletMapping(mapping), contextPath));
            }
            return new ProtocolMetaData().addContext((Object)httpContext);
        }
        catch (Exception e) {
            throw new DeploymentException("Failed to deploy " + archive.getName(), (Throwable)e);
        }
    }

    private Context workAroundTomcat51526(String url, String path) throws MalformedURLException {
        StandardContext ctx = new StandardContext();
        ctx.setName(url);
        ctx.setPath(url);
        ctx.setDocBase(path);
        ctx.setUnpackWAR(this.configuration.isUnpackArchive());
        ctx.setJ2EEServer("Arquillian-" + UUID.randomUUID().toString());
        ctx.addLifecycleListener((LifecycleListener)new Tomcat.DefaultWebXmlListener());
        EmbeddedContextConfig ctxCfg = new EmbeddedContextConfig();
        ctx.addLifecycleListener((LifecycleListener)ctxCfg);
        ctxCfg.setDefaultWebXml("org/apache/catalin/startup/NO_DEFAULT_XML");
        this.tomcat.getHost().addChild((Container)ctx);
        return ctx;
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        StandardContext standardContext = (StandardContext)this.standardContextProducer.get();
        if (standardContext != null) {
            this.host.removeChild((Container)standardContext);
            if (standardContext.getUnpackWAR()) {
                this.deleteUnpackedWAR((Context)standardContext);
            }
        }
    }

    private void undeploy(String name) throws DeploymentException {
        Container child = this.host.findChild(name);
        if (child != null) {
            this.host.removeChild(child);
        }
    }

    private void removeFailedUnDeployments() throws IOException {
        ArrayList remainingDeployments = new ArrayList();
        for (String name : this.failedUndeployments) {
            try {
                this.undeploy(name);
            }
            catch (Exception e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
        }
        if (remainingDeployments.size() > 0) {
            log.severe("Failed to undeploy these artifacts: " + remainingDeployments);
        }
        this.failedUndeployments.clear();
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    private File getTomcatHomeFile() throws LifecycleException {
        String tomcatHome = this.configuration.getTomcatHome();
        if (tomcatHome != null) {
            File tomcatHomeFile = new File(this.systemPropertiesUtil.substituteEvironmentVariable(tomcatHome));
            if (!tomcatHomeFile.exists() && !tomcatHomeFile.mkdirs()) {
                throw new LifecycleException("Unable to create home directory for Tomcat");
            }
            tomcatHomeFile.deleteOnExit();
            return tomcatHomeFile;
        }
        try {
            File tomcatHomeFile = File.createTempFile("tomcat-embedded-7", null);
            if (!tomcatHomeFile.delete() || !tomcatHomeFile.mkdirs()) {
                throw new LifecycleException("Unable to create temporary home directory " + tomcatHomeFile.getAbsolutePath() + " for Tomcat");
            }
            tomcatHomeFile.deleteOnExit();
            return tomcatHomeFile;
        }
        catch (IOException e) {
            throw new LifecycleException("Unable to create temporary home directory for Tomcat", (Throwable)e);
        }
    }

    private String getArchiveNameWithoutExtension(Archive<?> archive) {
        String archiveName = archive.getName();
        int extensionOffset = archiveName.lastIndexOf(46);
        String archiveNameWithoutExtension = extensionOffset >= 0 ? archiveName.substring(0, extensionOffset) : archiveName;
        return archiveNameWithoutExtension;
    }

    private void deleteUnpackedWAR(Context context) {
        File unpackDir = new File(this.host.getAppBase(), context.getPath().substring(1));
        if (unpackDir.exists()) {
            ExpandWar.deleteDir((File)unpackDir);
        }
    }
}

