/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.configuration.mapping;

import org.jboss.arquillian.drone.configuration.mapping.ValueMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum IntegerValueMapper implements ValueMapper<Integer>
{
    INSTANCE;


    @Override
    public boolean handles(Class<?> type, Class<?> ... parameters) {
        return Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type);
    }

    @Override
    public Integer transform(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Unable to convert value " + value + " to an integer.", e);
        }
    }
}

