/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.configuration;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.drone.configuration.mapping.BooleanValueMapper;
import org.jboss.arquillian.drone.configuration.mapping.MapValueMapper;
import org.jboss.arquillian.drone.configuration.mapping.ValueMapper;

public class CapabilityTypeMapper {
    private static final Logger log = Logger.getLogger(CapabilityTypeMapper.class.getName());
    private static final Map<String, ValueMapper<?>> TYPE_MAP = new HashMap();

    public static boolean isCastNeeded(String propertyName) {
        return TYPE_MAP.containsKey(propertyName);
    }

    public static Object createTypedObjectFromString(String propertyName, String value) {
        if (TYPE_MAP.containsKey(propertyName)) {
            try {
                return TYPE_MAP.get(propertyName).transform(value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("The property '" + propertyName + "' has value '" + value + "' that cannot be transformed using '" + TYPE_MAP.get(propertyName).getClass().getSimpleName() + "'.", e);
            }
        }
        log.log(Level.WARNING, "The type for property \"{0}\" cannot be determined, java.lang.String is used");
        return value;
    }

    static {
        TYPE_MAP.put("acceptSslCerts", BooleanValueMapper.INSTANCE);
        TYPE_MAP.put("webStorageEnabled", BooleanValueMapper.INSTANCE);
        TYPE_MAP.put("loggingPrefs", MapValueMapper.INSTANCE);
    }
}

