/*
 * JBoss, Home of Professional Open Source
 * Copyright 2013, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.arquillian.drone.spi.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

import org.jboss.arquillian.drone.api.annotation.Default;
import org.jboss.arquillian.drone.api.annotation.Qualifier;

/**
 * Representation of event related to Arquillian Drone extension
 *
 * @author <a href="mailto:kpiwko@redhat.com">Karel Piwko</a>
 *
 */
public interface DroneEvent {

    /**
     * Type of Drone instantiated. This reflect to {@link Field} type or parameter type specified next to Drone injection point.
     *
     * @return Type of Drone
     */
    Class<?> getDroneType();

    /**
     * Qualifier of Drone instance. See {@link Qualifier}. By default, if no qualifier is specified, it returns {@link Default}
     *
     * @return Qualifier associated with Drone
     */
    Class<? extends Annotation> getQualifier();

}
