/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.AbstractWebDriverFactory;
import org.jboss.arquillian.drone.webdriver.factory.BrowserCapabilitiesList;
import org.jboss.arquillian.drone.webdriver.factory.SecurityActions;
import org.jboss.arquillian.drone.webdriver.factory.Validate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlUnitDriverFactory
extends AbstractWebDriverFactory<HtmlUnitDriver>
implements Configurator<HtmlUnitDriver, WebDriverConfiguration>,
Instantiator<HtmlUnitDriver, WebDriverConfiguration>,
Destructor<HtmlUnitDriver> {
    private static final Logger log = Logger.getLogger(HtmlUnitDriverFactory.class.getName());
    private static final String BROWSER_CAPABILITIES = new BrowserCapabilitiesList.HtmlUnit().getReadableName();

    public int getPrecedence() {
        return 0;
    }

    public void destroyInstance(HtmlUnitDriver instance) {
        instance.quit();
    }

    public HtmlUnitDriver createInstance(WebDriverConfiguration configuration) {
        String applicationName = configuration.getApplicationName();
        String applicationVersion = configuration.getApplicationVersion();
        String userAgent = configuration.getUserAgent();
        float browserVersionNumeric = configuration.getBrowserVersionNumeric();
        Capabilities capabilities = configuration.getCapabilities();
        if (Validate.empty(applicationName) || Validate.empty(applicationVersion) || Validate.empty(userAgent)) {
            return SecurityActions.newInstance(configuration.getImplementationClass(), new Class[]{Capabilities.class}, new Object[]{capabilities}, HtmlUnitDriver.class);
        }
        log.log(Level.WARNING, "Creating HtmlUnitDriver using legacy configuration. ApplicationName={0} ApplicationVersion={1} UserAgent={2} BrowserVersionNumeric={3}", new Object[]{applicationName, applicationVersion, userAgent, Float.valueOf(browserVersionNumeric)});
        return SecurityActions.newInstance(configuration.getImplementationClass(), new Class[]{BrowserVersion.class}, new Object[]{new BrowserVersion(applicationName, applicationVersion, userAgent, browserVersionNumeric)}, HtmlUnitDriver.class);
    }

    @Override
    protected String getDriverReadableName() {
        return BROWSER_CAPABILITIES;
    }
}

